/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.nio.charset.Charset;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.util.ProcessIdentityProvider;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageFoundation;
import org.eclipse.store.storage.types.StorageLiveFileProvider;

public interface StorageLockFileSetup {
    public StorageLiveFileProvider lockFileProvider();

    public Charset charset();

    public String processIdentity();

    public long updateInterval();

    public static StorageLockFileSetup New(StorageLiveFileProvider lockFileProvider, ProcessIdentityProvider processIdentityProvider) {
        return StorageLockFileSetup.New(lockFileProvider, processIdentityProvider, Defaults.defaultCharset(), Defaults.defaultUpdateInterval());
    }

    public static StorageLockFileSetup New(StorageLiveFileProvider lockFileProvider, ProcessIdentityProvider processIdentityProvider, Charset charset, long updateInterval) {
        return new Default((StorageLiveFileProvider)X.notNull((Object)lockFileProvider), (ProcessIdentityProvider)X.notNull((Object)processIdentityProvider), (Charset)X.notNull((Object)charset), XMath.positive((long)updateInterval));
    }

    public static Provider Provider() {
        return StorageLockFileSetup.Provider(Defaults.defaultCharset(), Defaults.defaultUpdateInterval());
    }

    public static Provider Provider(Charset charset) {
        return StorageLockFileSetup.Provider(charset, Defaults.defaultUpdateInterval());
    }

    public static Provider Provider(long updateInterval) {
        return StorageLockFileSetup.Provider(Defaults.defaultCharset(), updateInterval);
    }

    public static Provider Provider(Charset charset, long updateInterval) {
        return new Provider.Default((Charset)X.notNull((Object)charset), XMath.positive((long)updateInterval));
    }

    @FunctionalInterface
    public static interface Provider {
        public StorageLockFileSetup provideLockFileSetup(StorageFoundation<?> var1);

        public static final class Default
        implements Provider {
            final Charset charset;
            final long updateInterval;

            Default(Charset charset, long updateInterval) {
                this.charset = charset;
                this.updateInterval = updateInterval;
            }

            @Override
            public StorageLockFileSetup provideLockFileSetup(StorageFoundation<?> foundation) {
                return StorageLockFileSetup.New(foundation.getConfiguration().fileProvider(), foundation.getProcessIdentityProvider(), this.charset, this.updateInterval);
            }
        }
    }

    public static final class Default
    implements StorageLockFileSetup {
        private final StorageLiveFileProvider lockFileProvider;
        private final ProcessIdentityProvider processIdentityProvider;
        private final Charset charset;
        private final long updateInterval;

        Default(StorageLiveFileProvider lockFileProvider, ProcessIdentityProvider processIdentityProvider, Charset charset, long updateInterval) {
            this.lockFileProvider = lockFileProvider;
            this.processIdentityProvider = processIdentityProvider;
            this.charset = charset;
            this.updateInterval = updateInterval;
        }

        @Override
        public final StorageLiveFileProvider lockFileProvider() {
            return this.lockFileProvider;
        }

        @Override
        public final String processIdentity() {
            return this.processIdentityProvider.provideProcessIdentity();
        }

        @Override
        public final long updateInterval() {
            return this.updateInterval;
        }

        @Override
        public final Charset charset() {
            return this.charset;
        }
    }

    public static interface Defaults {
        public static Charset defaultCharset() {
            return Persistence.standardCharset();
        }

        public static long defaultUpdateInterval() {
            return 10000L;
        }
    }
}

