/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.storage.types.StorageEntityCache;
import org.eclipse.store.storage.types.StorageEventLogger;
import org.eclipse.store.storage.types.StorageFoundation;
import org.slf4j.Logger;

public interface StorageHousekeepingController {
    public long housekeepingIntervalMs();

    public long housekeepingTimeBudgetNs();

    public long garbageCollectionTimeBudgetNs();

    public long liveCheckTimeBudgetNs();

    public long fileCheckTimeBudgetNs();

    public static StorageHousekeepingController New() {
        return new Default(Defaults.defaultHousekeepingIntervalMs(), Defaults.defaultHousekeepingTimeBudgetNs());
    }

    public static StorageHousekeepingController New(long housekeepingIntervalMs, long housekeepingTimeBudgetNs) {
        Validation.validateParameters(housekeepingIntervalMs, housekeepingTimeBudgetNs);
        return new Default(housekeepingIntervalMs, housekeepingTimeBudgetNs);
    }

    public static StorageHousekeepingController Adaptive(long increaseThresholdMs, long increaseAmountNs, long maximumTimeBudgetNs, StorageFoundation<?> foundation) {
        return StorageHousekeepingController.Adaptive(StorageHousekeepingController.New(), increaseThresholdMs, increaseAmountNs, maximumTimeBudgetNs, foundation);
    }

    public static StorageHousekeepingController Adaptive(StorageHousekeepingController delegate, long increaseThresholdMs, long increaseAmountNs, long maximumTimeBudgetNs, StorageFoundation<?> foundation) {
        Adaptive controller = new Adaptive((StorageHousekeepingController)X.notNull((Object)delegate), XMath.positive((long)increaseThresholdMs), XMath.positive((long)increaseAmountNs), XMath.positive((long)maximumTimeBudgetNs));
        foundation.addEventLogger(controller);
        return controller;
    }

    public static AdaptiveBuilder AdaptiveBuilder() {
        return StorageHousekeepingController.AdaptiveBuilder(StorageHousekeepingController.New());
    }

    public static AdaptiveBuilder AdaptiveBuilder(StorageHousekeepingController delegate) {
        return new AdaptiveBuilder.Default((StorageHousekeepingController)X.notNull((Object)delegate));
    }

    public static final class Adaptive
    implements StorageHousekeepingController,
    StorageEventLogger {
        private static final Logger logger = Logging.getLogger(Adaptive.class);
        private final StorageHousekeepingController delegate;
        private final long increaseThresholdMs;
        private final long increaseAmountNs;
        private final long maximumTimeBudgetNs;
        private long lastFinishedGCCycle = 0L;
        private long lastIncrease = 0L;
        private long currentIncreaseNs = 0L;

        Adaptive(StorageHousekeepingController delegate, long increaseThresholdMs, long increaseAmountNs, long maximumNsTimeBudget) {
            this.delegate = delegate;
            this.increaseThresholdMs = increaseThresholdMs;
            this.increaseAmountNs = increaseAmountNs;
            this.maximumTimeBudgetNs = maximumNsTimeBudget;
        }

        private synchronized void reset() {
            this.lastFinishedGCCycle = this.lastIncrease = System.currentTimeMillis();
            this.internalSetIncrease(0L);
        }

        private synchronized long increaseNs() {
            long now = System.currentTimeMillis();
            if (now - this.increaseThresholdMs > this.lastFinishedGCCycle && (this.lastIncrease <= 0L || now - this.lastIncrease > this.increaseThresholdMs)) {
                this.lastIncrease = now;
                this.internalSetIncrease(this.currentIncreaseNs + this.increaseAmountNs);
            }
            return this.currentIncreaseNs;
        }

        private void internalSetIncrease(long increaseNs) {
            this.currentIncreaseNs = Math.min(this.maximumTimeBudgetNs, increaseNs);
            logger.debug("Housekeeping time budgets increased by {} ns", (Object)String.format("%,d", this.currentIncreaseNs));
        }

        @Override
        public long housekeepingIntervalMs() {
            return this.delegate.housekeepingIntervalMs();
        }

        @Override
        public long housekeepingTimeBudgetNs() {
            return Math.min(this.maximumTimeBudgetNs, this.delegate.housekeepingTimeBudgetNs() + this.increaseNs());
        }

        @Override
        public long garbageCollectionTimeBudgetNs() {
            return Math.min(this.maximumTimeBudgetNs, this.delegate.garbageCollectionTimeBudgetNs() + this.increaseNs());
        }

        @Override
        public long liveCheckTimeBudgetNs() {
            return Math.min(this.maximumTimeBudgetNs, this.delegate.liveCheckTimeBudgetNs() + this.increaseNs());
        }

        @Override
        public long fileCheckTimeBudgetNs() {
            return Math.min(this.maximumTimeBudgetNs, this.delegate.fileCheckTimeBudgetNs() + this.increaseNs());
        }

        @Override
        public void logGarbageCollectorNotNeeded() {
            this.reset();
        }

        @Override
        public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
            this.reset();
        }

        public static interface Defaults {
            public static long defaultAdaptiveHousekeepingIncreaseThresholdMs() {
                return 5000L;
            }

            public static long defaultAdaptiveHousekeepingIncreaseAmountNs() {
                return 50000000L;
            }

            public static long defaultAdaptiveHousekeepingMaximumTimeBudgetNs() {
                return 500000000L;
            }
        }
    }

    public static interface AdaptiveBuilder {
        public AdaptiveBuilder increaseThresholdMs(long var1);

        public AdaptiveBuilder increaseAmountNs(long var1);

        public AdaptiveBuilder maximumTimeBudgetNs(long var1);

        public StorageHousekeepingController buildFor(StorageFoundation<?> var1);

        public static class Default
        implements AdaptiveBuilder {
            private final StorageHousekeepingController delegate;
            private long increaseThresholdMs = Adaptive.Defaults.defaultAdaptiveHousekeepingIncreaseThresholdMs();
            private long increaseAmountNs = Adaptive.Defaults.defaultAdaptiveHousekeepingIncreaseAmountNs();
            private long maximumTimeBudgetNs = Adaptive.Defaults.defaultAdaptiveHousekeepingMaximumTimeBudgetNs();

            Default(StorageHousekeepingController delegate) {
                this.delegate = delegate;
            }

            @Override
            public AdaptiveBuilder increaseThresholdMs(long increaseThresholdMs) {
                this.increaseThresholdMs = increaseThresholdMs;
                return this;
            }

            @Override
            public AdaptiveBuilder increaseAmountNs(long increaseAmountNs) {
                this.increaseAmountNs = increaseAmountNs;
                return this;
            }

            @Override
            public AdaptiveBuilder maximumTimeBudgetNs(long maximumTimeBudgetNs) {
                this.maximumTimeBudgetNs = maximumTimeBudgetNs;
                return this;
            }

            @Override
            public StorageHousekeepingController buildFor(StorageFoundation<?> foundation) {
                Adaptive controller = new Adaptive(this.delegate, this.increaseThresholdMs, this.increaseAmountNs, this.maximumTimeBudgetNs);
                foundation.addEventLogger(controller);
                return controller;
            }
        }
    }

    public static final class Default
    implements StorageHousekeepingController {
        private final long intervalMs;
        private final long nanoTimeBudget;

        Default(long intervalMs, long nanoTimeBudget) {
            this.intervalMs = intervalMs;
            this.nanoTimeBudget = nanoTimeBudget;
        }

        @Override
        public final long housekeepingIntervalMs() {
            return this.intervalMs;
        }

        @Override
        public final long housekeepingTimeBudgetNs() {
            return this.nanoTimeBudget;
        }

        @Override
        public final long garbageCollectionTimeBudgetNs() {
            return this.housekeepingTimeBudgetNs();
        }

        @Override
        public final long liveCheckTimeBudgetNs() {
            return this.housekeepingTimeBudgetNs();
        }

        @Override
        public final long fileCheckTimeBudgetNs() {
            return this.housekeepingTimeBudgetNs();
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().blank().add("house keeping interval").tab().add('=').blank().add(this.intervalMs).lf().blank().add("house keeping nano time budget").tab().add('=').blank().add(this.nanoTimeBudget).toString();
        }
    }

    public static interface Defaults {
        public static long defaultHousekeepingIntervalMs() {
            return 1000L;
        }

        public static long defaultHousekeepingTimeBudgetNs() {
            return 10000000L;
        }
    }

    public static interface Validation {
        public static long minimumHousekeepingIntervalMs() {
            return 1L;
        }

        public static long minimumHousekeepingTimeBudgetNs() {
            return 0L;
        }

        public static void validateParameters(long housekeepingIntervalMs, long housekeepingTimeBudgetNs) throws IllegalArgumentException {
            if (housekeepingIntervalMs < Validation.minimumHousekeepingIntervalMs()) {
                throw new IllegalArgumentException("Specified housekeeping millisecond interval of " + housekeepingIntervalMs + " is lower than the minimum value " + Validation.minimumHousekeepingIntervalMs() + ".");
            }
            if (housekeepingTimeBudgetNs < Validation.minimumHousekeepingTimeBudgetNs()) {
                throw new IllegalArgumentException("Specified housekeeping nanosecond time budget of " + housekeepingTimeBudgetNs + " is lower than the minimum value " + Validation.minimumHousekeepingTimeBudgetNs() + ".");
            }
        }
    }
}

