/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.util.function.Consumer;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.types.StorageDataFile;

public interface StorageFileNameProvider {
    public String provideChannelDirectoryName(int var1);

    public String channelDirectoryPrefix();

    public String dataFileType();

    public String transactionsFileType();

    public String rescuedFileType();

    public String typeDictionaryFileName();

    public String lockFileName();

    public String provideDataFileName(int var1, long var2);

    public String provideTransactionsFileName(int var1);

    public <F extends StorageDataFile> void parseDataInventoryFile(StorageDataFile.Creator<F> var1, Consumer<? super F> var2, int var3, AFile var4);

    public static StorageFileNameProvider New(String channelDirectoryPrefix, String dataFilePrefix, String dataFileSuffix, String transactionsFilePrefix, String transactionsFileSuffix, String rescuedFileSuffix, String typeDictionaryFileName, String lockFileName) {
        return new Default((String)X.notNull((Object)channelDirectoryPrefix), (String)X.notNull((Object)dataFilePrefix), (String)X.notNull((Object)dataFileSuffix), (String)X.notNull((Object)transactionsFilePrefix), (String)X.notNull((Object)transactionsFileSuffix), (String)X.notNull((Object)rescuedFileSuffix), (String)X.notNull((Object)typeDictionaryFileName), (String)X.notNull((Object)lockFileName));
    }

    public static Builder<?> Builder() {
        return new Builder.Default();
    }

    public static interface Builder<B extends Builder<?>> {
        public String channelDirectoryPrefix();

        public B setChannelDirectoryPrefix(String var1);

        public String dataFilePrefix();

        public B setDataFilePrefix(String var1);

        public String dataFileSuffix();

        public B setDataFileSuffix(String var1);

        public String transactionsFilePrefix();

        public B setTransactionsFilePrefix(String var1);

        public String transactionsFileSuffix();

        public B setTransactionsFileSuffix(String var1);

        public String rescuedFileSuffix();

        public B setRescuedFileSuffix(String var1);

        public String typeDictionaryFileName();

        public B setTypeDictionaryFileName(String var1);

        public String lockFileName();

        public B setLockFileName(String var1);

        public StorageFileNameProvider createFileNameProvider();

        public static org.eclipse.store.storage.types.StorageFileNameProvider$Default New(String channelDirectoryPrefix, String storageFilePrefix, String storageFileSuffix, String transactionsFilePrefix, String transactionsFileSuffix, String rescuedFileSuffix, String typeDictionaryFileName, String lockFileName) {
            return new org.eclipse.store.storage.types.StorageFileNameProvider$Default((String)X.notNull((Object)channelDirectoryPrefix), (String)X.notNull((Object)storageFilePrefix), (String)X.notNull((Object)storageFileSuffix), (String)X.notNull((Object)transactionsFilePrefix), (String)X.notNull((Object)transactionsFileSuffix), (String)X.notNull((Object)rescuedFileSuffix), (String)X.notNull((Object)typeDictionaryFileName), (String)X.notNull((Object)lockFileName));
        }

        public static class Default<B extends Default<?>>
        implements Builder<B> {
            private String channelDirectoryPrefix;
            private String dataFilePrefix;
            private String dataFileSuffix;
            private String transactionsFilePrefix;
            private String transactionsFileSuffix;
            private String rescuedFileSuffix;
            private String typeDictionaryFileName;
            private String lockFileName;

            Default() {
            }

            protected final B $() {
                return (B)this;
            }

            @Override
            public String channelDirectoryPrefix() {
                return this.channelDirectoryPrefix;
            }

            @Override
            public B setChannelDirectoryPrefix(String channelDirectoryPrefix) {
                this.channelDirectoryPrefix = channelDirectoryPrefix;
                return this.$();
            }

            @Override
            public String dataFilePrefix() {
                return this.dataFilePrefix;
            }

            @Override
            public B setDataFilePrefix(String dataFilePrefix) {
                this.dataFilePrefix = dataFilePrefix;
                return this.$();
            }

            @Override
            public String dataFileSuffix() {
                return this.dataFileSuffix;
            }

            @Override
            public B setDataFileSuffix(String dataFileSuffix) {
                this.dataFileSuffix = dataFileSuffix;
                return this.$();
            }

            @Override
            public String transactionsFilePrefix() {
                return this.transactionsFilePrefix;
            }

            @Override
            public B setTransactionsFilePrefix(String transactionsFilePrefix) {
                this.transactionsFilePrefix = transactionsFilePrefix;
                return this.$();
            }

            @Override
            public String transactionsFileSuffix() {
                return this.transactionsFileSuffix;
            }

            @Override
            public B setTransactionsFileSuffix(String transactionsFileSuffix) {
                this.transactionsFileSuffix = transactionsFileSuffix;
                return this.$();
            }

            @Override
            public String rescuedFileSuffix() {
                return this.rescuedFileSuffix;
            }

            @Override
            public B setRescuedFileSuffix(String rescuedFileSuffix) {
                this.rescuedFileSuffix = rescuedFileSuffix;
                return this.$();
            }

            @Override
            public String typeDictionaryFileName() {
                return this.typeDictionaryFileName;
            }

            @Override
            public B setTypeDictionaryFileName(String typeDictionaryFileName) {
                this.typeDictionaryFileName = typeDictionaryFileName;
                return this.$();
            }

            @Override
            public String lockFileName() {
                return this.lockFileName;
            }

            @Override
            public B setLockFileName(String lockFileName) {
                this.lockFileName = lockFileName;
                return this.$();
            }

            @Override
            public StorageFileNameProvider createFileNameProvider() {
                return StorageFileNameProvider.New((String)X.coalesce((Object)this.channelDirectoryPrefix, (Object)Defaults.defaultChannelDirectoryPrefix()), (String)X.coalesce((Object)this.dataFilePrefix, (Object)Defaults.defaultDataFilePrefix()), (String)X.coalesce((Object)this.dataFileSuffix, (Object)Defaults.defaultDataFileSuffix()), (String)X.coalesce((Object)this.transactionsFilePrefix, (Object)Defaults.defaultTransactionsFilePrefix()), (String)X.coalesce((Object)this.transactionsFileSuffix, (Object)Defaults.defaultTransactionsFileSuffix()), (String)X.coalesce((Object)this.rescuedFileSuffix, (Object)Defaults.defaultRescuedFileSuffix()), (String)X.coalesce((Object)this.typeDictionaryFileName, (Object)Defaults.defaultTypeDictionaryFileName()), (String)X.coalesce((Object)this.lockFileName, (Object)Defaults.defaultLockFileName()));
            }
        }
    }

    public static final class Default
    implements StorageFileNameProvider {
        static final Default DEFAULT = new Default(Defaults.defaultChannelDirectoryPrefix(), Defaults.defaultDataFilePrefix(), Defaults.defaultDataFileSuffix(), Defaults.defaultTransactionsFilePrefix(), Defaults.defaultTransactionsFileSuffix(), Defaults.defaultRescuedFileSuffix(), Defaults.defaultTypeDictionaryFileName(), Defaults.defaultLockFileName());
        private final String channelDirectoryPrefix;
        private final String dataFilePrefix;
        private final String dataFileType;
        private final String transactionsFilePrefix;
        private final String transactionsFileType;
        private final String rescuedFileType;
        private final String typeDictionaryFileName;
        private final String lockFileName;

        Default(String channelDirectoryPrefix, String dataFilePrefix, String dataFileType, String transactionsFilePrefix, String transactionsFileType, String rescuedFileType, String typeDictionaryFileName, String lockFileName) {
            this.channelDirectoryPrefix = channelDirectoryPrefix;
            this.dataFilePrefix = dataFilePrefix;
            this.dataFileType = dataFileType;
            this.transactionsFilePrefix = transactionsFilePrefix;
            this.transactionsFileType = transactionsFileType;
            this.rescuedFileType = rescuedFileType;
            this.typeDictionaryFileName = typeDictionaryFileName;
            this.lockFileName = lockFileName;
        }

        public String dataFilePrefix() {
            return this.dataFilePrefix;
        }

        public String transactionsFilePrefix() {
            return this.transactionsFilePrefix;
        }

        @Override
        public String channelDirectoryPrefix() {
            return this.channelDirectoryPrefix;
        }

        @Override
        public String provideChannelDirectoryName(int hashIndex) {
            return this.channelDirectoryPrefix() + hashIndex;
        }

        @Override
        public String dataFileType() {
            return this.dataFileType;
        }

        @Override
        public String transactionsFileType() {
            return this.transactionsFileType;
        }

        @Override
        public String rescuedFileType() {
            return this.rescuedFileType;
        }

        @Override
        public String typeDictionaryFileName() {
            return this.typeDictionaryFileName;
        }

        @Override
        public String lockFileName() {
            return this.lockFileName;
        }

        @Override
        public final String provideDataFileName(int channelIndex, long fileNumber) {
            return this.dataFilePrefix + channelIndex + "_" + fileNumber;
        }

        @Override
        public final String provideTransactionsFileName(int channelIndex) {
            return this.transactionsFilePrefix + channelIndex;
        }

        @Override
        public <F extends StorageDataFile> void parseDataInventoryFile(StorageDataFile.Creator<F> fileCreator, Consumer<? super F> collector, int channelIndex, AFile file) {
            long fileNumber;
            String filename = file.name();
            if (!filename.startsWith(this.dataFilePrefix)) {
                return;
            }
            if (!this.dataFileType.equals(file.type())) {
                return;
            }
            String middlePart = filename.substring(this.dataFilePrefix.length());
            int separatorIndex = middlePart.indexOf(95);
            if (separatorIndex < 0) {
                throw new StorageException("Invalid data file name: " + file);
            }
            String hashIndexString = middlePart.substring(0, separatorIndex);
            try {
                if (Integer.parseInt(hashIndexString) != channelIndex) {
                    throw new StorageException("Invalid channel for data file: " + file);
                }
            }
            catch (NumberFormatException e) {
                throw new StorageException("Invalid data file name: " + file);
            }
            String fileNumberString = middlePart.substring(separatorIndex + 1);
            try {
                fileNumber = Long.parseLong(fileNumberString);
            }
            catch (NumberFormatException e) {
                throw new StorageException("Invalid data file name: " + file);
            }
            collector.accept(fileCreator.createDataFile(file, channelIndex, fileNumber));
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().blank().add("channel directory prefix").tab().add('=').blank().add(this.channelDirectoryPrefix).lf().blank().add("storage file prefix").tab().add('=').blank().add(this.dataFilePrefix).lf().blank().add("file suffix").tab().add('=').blank().add(this.dataFileType).lf().blank().add("lockFileName").tab().add('=').blank().add(this.lockFileName).toString();
        }
    }

    public static interface Defaults {
        public static String defaultChannelDirectoryPrefix() {
            return "channel_";
        }

        public static String defaultDataFilePrefix() {
            return "channel_";
        }

        public static String defaultDataFileSuffix() {
            return "dat";
        }

        public static String defaultTransactionsFilePrefix() {
            return "transactions_";
        }

        public static String defaultTransactionsFileSuffix() {
            return "sft";
        }

        public static String defaultRescuedFileSuffix() {
            return "bak";
        }

        public static String defaultTypeDictionaryFileName() {
            return Persistence.defaultFilenameTypeDictionary();
        }

        public static String defaultLockFileName() {
            return "used.lock";
        }

        public static StorageFileNameProvider defaultFileNameProvider() {
            return Default.DEFAULT;
        }
    }
}

