/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.collections.types.XImmutableTable;
import org.eclipse.serializer.typing.KeyValue;

public interface StorageEntityTypeExportStatistics {
    public long entityCount();

    public long bytesWritten();

    public long startTime();

    public long finishTime();

    public XGettingTable<Long, ? extends TypeStatistic> typeStatistics();

    public XGettingTable<Integer, ? extends ChannelStatistic> channelStatistics();

    public XGettingEnum<AFile> files();

    public static interface ChannelStatistic {
        public long entityCount();

        public long bytesWritten();

        public long startTime();

        public long finishTime();

        public int channelIndex();

        public XGettingTable<Long, ? extends TypeStatistic> typeStatistics();

        public void assembleTableRecord(VarString var1);

        public static final class Default
        extends AbstractStatistic
        implements ChannelStatistic {
            final int channelIndex;
            final XImmutableTable<Long, TypeStatistic.Default> typeStatistics;

            Default(int channelIndex, XGettingTable<Long, TypeStatistic.Default> typeStatistics) {
                this.channelIndex = channelIndex;
                this.typeStatistics = EqConstHashTable.New(typeStatistics);
                for (TypeStatistic.Default tr : typeStatistics.values()) {
                    this.update(tr.entityCount, tr.bytesWritten, tr.tStart, tr.tEnd);
                }
            }

            @Override
            public final int channelIndex() {
                return this.channelIndex;
            }

            @Override
            public final XGettingTable<Long, ? extends TypeStatistic> typeStatistics() {
                return this.typeStatistics;
            }

            @Override
            public final void assembleTableRecord(VarString vs) {
                String channelIdentifier = Integer.toString(this.channelIndex);
                org.eclipse.store.storage.types.StorageEntityTypeExportStatistics$Default.assembleTableHeader(vs);
                super.assembleTableRecord(vs, channelIdentifier);
                vs.tab().tab().tab();
                org.eclipse.store.storage.types.StorageEntityTypeExportStatistics$Default.assembleTableHeader(vs);
                for (TypeStatistic.Default e : this.typeStatistics.values()) {
                    e.assembleTableRecord(vs, channelIdentifier);
                }
            }
        }
    }

    public static interface TypeStatistic {
        public long entityCount();

        public long bytesWritten();

        public long startTime();

        public long finishTime();

        public long typeId();

        public String typeName();

        public AFile file();

        public static final class Default
        extends AbstractStatistic
        implements TypeStatistic {
            final long typeId;
            final String typeName;
            final AFile file;

            Default(long typeId, String typeName, AFile file) {
                this.typeId = typeId;
                this.typeName = typeName;
                this.file = file;
            }

            @Override
            public final long typeId() {
                return this.typeId;
            }

            @Override
            public final String typeName() {
                return this.typeName;
            }

            @Override
            public final AFile file() {
                return this.file;
            }

            @Override
            final void assembleTableRecord(VarString vs, String channel) {
                super.assembleTableRecord(vs, channel);
                vs.tab().add(this.typeId).tab().add(this.typeName).tab().add(this.file.identifier());
            }
        }
    }

    public static abstract class AbstractStatistic {
        long entityCount;
        long bytesWritten;
        long tLongest;
        long tTotal;
        long tEnd;
        long tStart = Long.MAX_VALUE;

        final void update(long entityCount, long bytesWritten, long tStart, long tEnd) {
            this.entityCount += entityCount;
            this.bytesWritten += bytesWritten;
            this.tStart = Math.min(this.tStart, tStart);
            this.tEnd = Math.max(this.tEnd, tEnd);
            this.tLongest = Math.max(this.tLongest, tEnd - tStart);
            this.tTotal += tEnd - tStart;
        }

        public final long entityCount() {
            return this.entityCount;
        }

        public final long bytesWritten() {
            return this.bytesWritten;
        }

        public final long startTime() {
            return this.tStart;
        }

        public final long finishTime() {
            return this.tEnd;
        }

        public final long longestDuration() {
            return this.tLongest;
        }

        public final long totalDuration() {
            return this.tTotal;
        }

        void assembleTableRecord(VarString vs, String channel) {
            vs.lf().add(channel).tab().add(this.entityCount).tab().add(this.bytesWritten).tab().add(this.tStart).tab().add(this.tEnd).tab().add(this.tTotal).tab().add(this.tLongest);
        }
    }

    public static final class Default
    extends AbstractStatistic
    implements StorageEntityTypeExportStatistics {
        private static final String[] TABLE_COLUMN_NAMES = new String[]{"Channel", "Entity Count", "Byte Count", "Start Time", "Finish Time", "Total Time", "Longest Time", "Type Id", "Type Name", "Type File"};
        final XGettingTable<Long, TypeStatistic.Default> typeStatistics;
        final XGettingTable<Long, TypeStatistic.Default> viewTypeStatistics;
        final XGettingTable<Integer, ? extends ChannelStatistic> channelStatistics;
        final XGettingTable<Integer, ? extends ChannelStatistic> viewChannelStatistics;

        public static final void assembleTableHeader(VarString vs) {
            XChars.assembleNewLinedTabbed((VarString)vs, (CharSequence[])TABLE_COLUMN_NAMES);
        }

        Default(XGettingTable<Integer, ? extends ChannelStatistic> channelStatistics) {
            EqHashTable typeStatistics = EqHashTable.New();
            for (KeyValue e1 : channelStatistics) {
                ChannelStatistic cs = (ChannelStatistic)e1.value();
                this.update(cs.entityCount(), cs.bytesWritten(), cs.startTime(), cs.finishTime());
                for (KeyValue e2 : cs.typeStatistics()) {
                    TypeStatistic cts = (TypeStatistic)e2.value();
                    TypeStatistic.Default ts = (TypeStatistic.Default)typeStatistics.get((Object)((Long)e2.key()));
                    if (ts == null) {
                        ts = new TypeStatistic.Default(cts.typeId(), cts.typeName(), cts.file());
                        typeStatistics.add((Object)((Long)e2.key()), (Object)ts);
                    }
                    ts.update(cts.entityCount(), cts.bytesWritten(), cts.startTime(), cts.finishTime());
                }
            }
            this.typeStatistics = typeStatistics;
            this.viewTypeStatistics = this.typeStatistics.view();
            this.channelStatistics = channelStatistics;
            this.viewChannelStatistics = this.channelStatistics.view();
        }

        @Override
        public final XGettingTable<Long, ? extends TypeStatistic> typeStatistics() {
            return this.viewTypeStatistics;
        }

        @Override
        public final XGettingTable<Integer, ? extends ChannelStatistic> channelStatistics() {
            return this.viewChannelStatistics;
        }

        @Override
        public XGettingEnum<AFile> files() {
            EqHashEnum files = EqHashEnum.New();
            this.viewTypeStatistics.values().forEach(s -> files.add((Object)s.file()));
            return files.immure();
        }

        final void assembleTableRecord(VarString vs) {
            vs.add("Total");
            Default.assembleTableHeader(vs);
            super.assembleTableRecord(vs, "");
            vs.tab().tab().tab();
            vs.lf().add("Total per Type:");
            Default.assembleTableHeader(vs);
            for (Object e : this.typeStatistics.values()) {
                ((TypeStatistic.Default)e).assembleTableRecord(vs, "");
            }
            vs.lf().add("Per Channel:");
            for (Object e : this.channelStatistics.values()) {
                e.assembleTableRecord(vs);
            }
        }

        public final String toString() {
            VarString vs = VarString.New((int)1000000);
            this.assembleTableRecord(vs);
            return vs.toString();
        }
    }
}

