/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.util.function.Predicate;
import org.eclipse.serializer.functional.ThrowingProcedure;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.types.StorageEntity;
import org.eclipse.store.storage.types.StorageEntityTypeHandler;
import org.eclipse.store.storage.types.StorageIdAnalysis;
import org.eclipse.store.storage.types.TypeInFile;

public interface StorageEntityType<E extends StorageEntity> {
    public StorageEntityTypeHandler typeHandler();

    public long entityCount();

    default public boolean isEmpty() {
        return this.entityCount() == 0L;
    }

    public <T extends Throwable, P extends ThrowingProcedure<? super E, T>> P iterateEntities(P var1) throws T;

    public boolean hasReferences();

    public long simpleReferenceDataCount();

    public void iterateEntityReferenceIds(E var1, PersistenceObjectIdAcceptor var2);

    public StorageIdAnalysis validateEntities();

    public static final class Default
    implements StorageEntityType<StorageEntity.Default> {
        final int channelIndex;
        final long typeId;
        private final StorageEntityTypeHandler typeHandler;
        private final boolean hasReferences;
        private final long simpleReferenceDataCount;
        private long entityCount;
        Default hashNext;
        Default next;
        final TypeInFile dummy = new TypeInFile(this, null, null);
        StorageEntity.Default head;
        StorageEntity.Default tail = this.head = StorageEntity.Default.createDummy(this.dummy);

        Default(int channelIndex) {
            this.channelIndex = channelIndex;
            this.typeId = -1L;
            this.typeHandler = null;
            this.hasReferences = false;
            this.simpleReferenceDataCount = 0L;
            this.next = this;
        }

        Default(int channelIndex, StorageEntityTypeHandler typeHandler, Default hashNext, Default next) {
            this.channelIndex = channelIndex;
            this.hasReferences = typeHandler.hasPersistedReferences();
            this.simpleReferenceDataCount = typeHandler.simpleReferenceCount();
            this.typeId = typeHandler.typeId();
            this.typeHandler = typeHandler;
            this.hashNext = hashNext;
            this.next = next;
        }

        final void add(StorageEntity.Default entry) {
            this.tail = this.tail.typeNext = entry;
            ++this.entityCount;
        }

        final void remove(StorageEntity.Default entry, StorageEntity.Default previousInType) {
            if (entry == this.tail) {
                this.tail = previousInType;
                previousInType.typeNext = null;
            } else {
                previousInType.typeNext = entry.typeNext;
            }
            --this.entityCount;
        }

        @Override
        public <T extends Throwable, P extends ThrowingProcedure<? super StorageEntity.Default, T>> P iterateEntities(P procedure) throws T {
            StorageEntity.Default entity = this.head;
            while ((entity = entity.typeNext) != null) {
                procedure.accept((Object)entity);
            }
            return procedure;
        }

        public <P extends EntityDeleter> P removeAll(P deleter) {
            StorageEntity.Default entity = this.head;
            while (true) {
                StorageEntity.Default last = entity;
                entity = last.typeNext;
                if (entity == null) break;
                if (!deleter.test(entity)) continue;
                deleter.delete(entity, this, last);
                entity = last;
            }
            return deleter;
        }

        @Override
        public final StorageEntityTypeHandler typeHandler() {
            return this.typeHandler;
        }

        @Override
        public final long entityCount() {
            return this.entityCount;
        }

        @Override
        public final boolean hasReferences() {
            return this.hasReferences;
        }

        @Override
        public final long simpleReferenceDataCount() {
            return this.simpleReferenceDataCount;
        }

        @Override
        public final void iterateEntityReferenceIds(StorageEntity.Default entity, PersistenceObjectIdAcceptor iterator) {
            this.typeHandler.iterateReferences(entity.cacheAddress(), iterator);
        }

        @Override
        public StorageIdAnalysis validateEntities() {
            StorageEntityTypeHandler typeHandler = this.typeHandler;
            long maxObjectId = 0L;
            long maxConstantId = 0L;
            long maxTypeId = 0L;
            StorageEntity.Default entity = this.head;
            while ((entity = entity.typeNext) != null) {
                long entityLength = entity.length;
                long entityObjectId = entity.objectId();
                typeHandler.validateEntityGuaranteedType(entityLength, entityObjectId);
                long objectId = entity.objectId();
                if (Persistence.IdType.OID.isInRange(objectId)) {
                    if (objectId < maxObjectId) continue;
                    maxObjectId = objectId;
                    continue;
                }
                if (Persistence.IdType.CID.isInRange(objectId)) {
                    if (objectId < maxConstantId) continue;
                    maxConstantId = objectId;
                    continue;
                }
                throw new StorageException("Invalid OID: " + objectId);
            }
            return StorageIdAnalysis.New(0L, maxObjectId, maxConstantId);
        }

        public String toString() {
            return "Ch#" + this.channelIndex + "_" + (this.typeHandler == null ? "<Dummy Type>" : this.typeHandler.toString());
        }

        public static interface EntityDeleter
        extends Predicate<StorageEntity.Default> {
            @Override
            public boolean test(StorageEntity.Default var1);

            public void delete(StorageEntity.Default var1, Default var2, StorageEntity.Default var3);
        }
    }
}

