/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.meta.XDebug;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryEntityRawDataAcceptor;
import org.eclipse.serializer.util.UtilStackTrace;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageEntityTypeHandler;
import org.eclipse.store.storage.types.StorageTypeDictionary;

@FunctionalInterface
public interface StorageEntityDataValidator
extends BinaryEntityRawDataAcceptor {
    default public boolean acceptEntityData(long entityStartAddress, long dataBoundAddress) {
        if (entityStartAddress + (long)Binary.entityHeaderLength() > dataBoundAddress) {
            return false;
        }
        this.validateEntity(Binary.getEntityLengthRawValue((long)entityStartAddress), Binary.getEntityTypeIdRawValue((long)entityStartAddress), Binary.getEntityObjectIdRawValue((long)entityStartAddress));
        return true;
    }

    public void validateEntity(long var1, long var3, long var5);

    public static StorageEntityDataValidator New(StorageTypeDictionary typeDictionary) {
        return new ByDictionary((StorageTypeDictionary)X.notNull((Object)typeDictionary));
    }

    public static StorageEntityDataValidator New(long lengthLowerValue, long lengthUpperBound, long typeIdLowerValue, long typeIdUpperBound, long objectIdLowerValue, long objectIdUpperBound) {
        return new SimpleBounds(lengthLowerValue, lengthUpperBound, typeIdLowerValue, typeIdUpperBound, objectIdLowerValue, objectIdUpperBound);
    }

    @Deprecated
    public static StorageEntityDataValidator DebugLogging(StorageEntityDataValidator delegate) {
        return new DebugLogger((StorageEntityDataValidator)X.notNull((Object)delegate));
    }

    @Deprecated
    public static StorageEntityDataValidator DebugLogging(StorageTypeDictionary typeDictionary) {
        return StorageEntityDataValidator.DebugLogging(StorageEntityDataValidator.New(typeDictionary));
    }

    public static Creator Creator() {
        return new Creator.Default();
    }

    @Deprecated
    public static Creator CreatorDebugLogging() {
        return new Creator.DebugLogging();
    }

    public static interface Creator {
        public StorageEntityDataValidator createDataFileValidator(StorageTypeDictionary var1);

        @Deprecated
        public static final class DebugLogging
        implements Creator {
            DebugLogging() {
            }

            @Override
            public StorageEntityDataValidator createDataFileValidator(StorageTypeDictionary typeDictionary) {
                return StorageEntityDataValidator.DebugLogging(typeDictionary);
            }
        }

        public static final class Default
        implements Creator {
            Default() {
            }

            @Override
            public StorageEntityDataValidator createDataFileValidator(StorageTypeDictionary typeDictionary) {
                return StorageEntityDataValidator.New(typeDictionary);
            }
        }
    }

    public static class ByDictionary
    implements StorageEntityDataValidator {
        private final StorageTypeDictionary typeDictionary;

        protected ByDictionary(StorageTypeDictionary typeDictionary) {
            this.typeDictionary = (StorageTypeDictionary)X.notNull((Object)typeDictionary);
        }

        @Override
        public void validateEntity(long length, long typeId, long objectId) {
            StorageEntityTypeHandler typeHandler = this.typeDictionary.lookupTypeHandlerChecked(typeId);
            typeHandler.validateEntityGuaranteedType(length, objectId);
        }
    }

    public static class SimpleBounds
    implements StorageEntityDataValidator {
        private final long lengthLowerValue;
        private final long lengthUpperBound;
        private final long typeIdLowerValue;
        private final long typeIdUpperBound;
        private final long objectIdLowerValue;
        private final long objectIdUpperBound;

        SimpleBounds(long lengthLowerValue, long lengthUpperBound, long typeIdLowerValue, long typeIdUpperBound, long objectIdLowerValue, long objectIdUpperBound) {
            this.lengthLowerValue = lengthLowerValue;
            this.lengthUpperBound = lengthUpperBound;
            this.typeIdLowerValue = typeIdLowerValue;
            this.typeIdUpperBound = typeIdUpperBound;
            this.objectIdLowerValue = objectIdLowerValue;
            this.objectIdUpperBound = objectIdUpperBound;
        }

        private static boolean isValid(long lowerValue, long upperBound, long value) {
            if (value < lowerValue) {
                return false;
            }
            return value < upperBound;
        }

        private static RuntimeException createException(long length, long typeId, long objectId) {
            return (RuntimeException)UtilStackTrace.cutStacktraceByOne((Throwable)new RuntimeException("[" + length + "][" + typeId + "][" + objectId + "]"));
        }

        @Override
        public void validateEntity(long length, long typeId, long objectId) {
            if (!SimpleBounds.isValid(this.lengthLowerValue, this.lengthUpperBound, length)) {
                throw SimpleBounds.createException(length, typeId, objectId);
            }
            if (!SimpleBounds.isValid(this.typeIdLowerValue, this.typeIdUpperBound, typeId)) {
                throw SimpleBounds.createException(length, typeId, objectId);
            }
            if (!SimpleBounds.isValid(this.objectIdLowerValue, this.objectIdUpperBound, objectId)) {
                throw SimpleBounds.createException(length, typeId, objectId);
            }
        }
    }

    public static final class DebugLogger
    implements StorageEntityDataValidator {
        private final StorageEntityDataValidator delegate;

        DebugLogger(StorageEntityDataValidator delegate) {
            this.delegate = delegate;
        }

        @Override
        public void validateEntity(long length, long typeId, long objectId) {
            XDebug.println((String)("Validating entity [" + length + "][" + typeId + "][" + objectId + "]"));
            this.delegate.validateEntity(length, typeId, objectId);
        }
    }
}

