/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.afs.types.AWritableFile;
import org.eclipse.serializer.functional.ThrowingProcedure;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.MemoryRangeReader;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.store.storage.types.StorageLiveDataFile;
import org.eclipse.store.storage.types.TypeInFile;

public interface StorageEntity {
    public long dataLength();

    public long typeId();

    public long objectId();

    public boolean hasReferences();

    public long cachedDataLength();

    public long lastTouched();

    public long storagePosition();

    public StorageLiveDataFile storageFile();

    public void copyCachedData(MemoryRangeReader var1);

    public long clearCache();

    public boolean iterateReferenceIds(PersistenceObjectIdAcceptor var1);

    public long exportTo(AWritableFile var1);

    public static final class MinObjectId
    implements ThrowingProcedure<StorageEntity, RuntimeException> {
        private long minObjectId;

        public final MinObjectId reset() {
            this.minObjectId = Long.MAX_VALUE;
            return this;
        }

        public final void accept(StorageEntity e) {
            if (e.objectId() < this.minObjectId) {
                this.minObjectId = e.objectId();
            }
        }

        public final long yield() {
            return this.minObjectId == Long.MAX_VALUE ? 0L : this.minObjectId;
        }
    }

    public static final class MaxObjectId
    implements ThrowingProcedure<StorageEntity, RuntimeException> {
        private long maxObjectId;

        public final MaxObjectId reset() {
            this.maxObjectId = 0L;
            return this;
        }

        public final void accept(StorageEntity e) {
            if (e.objectId() >= this.maxObjectId) {
                this.maxObjectId = e.objectId();
            }
        }

        public final long yield() {
            return this.maxObjectId;
        }
    }

    public static final class Default
    implements StorageEntity {
        private static final long TOUCHED_SHIFT_COUNT = 8L;
        private static final long TOUCHED_START_OFFSET = System.currentTimeMillis();
        static final byte GC_BLACK = 2;
        static final byte GC_GRAY = 1;
        static final byte GC_INITIAL = 0;
        static final byte GC_WHITE = -1;
        final long objectId;
        long cacheAddress;
        int storagePosition;
        int length;
        int lastTouched;
        byte gcState;
        boolean isDeleted;
        boolean onlyRefsCached;
        byte referenceCount;
        TypeInFile typeInFile;
        Default filePrev;
        Default fileNext;
        Default hashNext;
        Default typeNext;

        static final Default createDummy() {
            return Default.createDummy(null);
        }

        static final Default createDummy(TypeInFile type) {
            return new Default(0L, type, null, 0);
        }

        static Default New(long objectId, TypeInFile type, Default hashNext, boolean hasReferences, long simpleReferenceCount) {
            return new Default(objectId, type, hashNext, Default.calculateReferenceCount(hasReferences, simpleReferenceCount));
        }

        private Default(long objectId, TypeInFile type, Default hashNext, byte referenceCount) {
            this.objectId = objectId;
            this.hashNext = hashNext;
            this.lastTouched = Integer.MAX_VALUE;
            this.typeInFile = type;
            this.referenceCount = referenceCount;
            this.gcState = 0;
        }

        private static byte calculateReferenceCount(boolean hasReferences, long simpleReferenceCount) {
            if (!hasReferences) {
                return 0;
            }
            if (simpleReferenceCount <= 0L || simpleReferenceCount > 127L) {
                return -1;
            }
            return (byte)simpleReferenceCount;
        }

        final boolean isGcGray() {
            return this.gcState == 1;
        }

        final void markInitial() {
            this.gcState = 0;
        }

        final void markGray() {
            this.gcState = 1;
        }

        final boolean isGcBlack() {
            return this.gcState == 2;
        }

        final void markBlack() {
            this.gcState = (byte)2;
        }

        final void markWhite() {
            this.gcState = (byte)-1;
        }

        final boolean isGcAlreadyHandled() {
            return this.gcState >= 1;
        }

        final boolean isGcMarked() {
            return this.gcState >= 0;
        }

        final boolean hasOnlySimpleReferencesLoaded() {
            return this.onlyRefsCached;
        }

        final void setSimpleReferencesLoaded() {
            this.onlyRefsCached = true;
        }

        final void clearSimpleReferencesLoaded() {
            this.onlyRefsCached = false;
        }

        final int simpleReferenceCount() {
            return this.referenceCount;
        }

        final boolean hasSimpleReferences() {
            return this.referenceCount > 0;
        }

        final boolean isLive() {
            return this.cacheAddress != 0L;
        }

        private long calculateSimpleReferenceCacheLength() {
            return Binary.entityTotalLength((long)Binary.referenceBinaryLength((long)this.simpleReferenceCount()));
        }

        private boolean ensureCachedReferenceData() {
            if (this.isLive()) {
                return false;
            }
            if (this.hasSimpleReferences()) {
                this.loadData(this.calculateSimpleReferenceCacheLength());
                this.setSimpleReferencesLoaded();
            } else {
                this.internalLoadFullEntityData();
            }
            return true;
        }

        private void ensureCachedFullData() {
            if (this.hasOnlySimpleReferencesLoaded()) {
                this.internalLoadData(this.length, (long)this.length - this.clearCache());
            } else if (!this.isLive()) {
                this.internalLoadFullEntityData();
            }
        }

        private void loadData(long length) {
            this.internalLoadData(length, length);
        }

        private void internalLoadData(long length, long cacheChange) {
            this.typeInFile.file.loadEntityData(this, length, cacheChange);
        }

        private void internalLoadFullEntityData() {
            this.internalLoadData(this.length, this.length);
            this.clearSimpleReferencesLoaded();
        }

        final void detachFromFile() {
            this.typeInFile.file.remove(this);
        }

        final void putCacheData(long sourceAddress, long length) {
            this.cacheAddress = XMemory.allocate((long)length);
            XMemory.copyRange((long)sourceAddress, (long)this.cacheAddress, (long)length);
        }

        final void updateStorageInformation(int length, int storagePosition) {
            this.storagePosition = storagePosition;
            this.length = length;
        }

        final boolean isProper() {
            return this.typeInFile != null;
        }

        final boolean isExisting() {
            return !this.isDeleted() && this.isProper();
        }

        final boolean isDeleted() {
            return this.isDeleted;
        }

        final void setDeleted() {
            this.isDeleted = true;
        }

        final long cacheAddress() {
            return this.cacheAddress;
        }

        @Override
        public final long dataLength() {
            return this.length;
        }

        @Override
        public long typeId() {
            return this.typeInFile.type.typeId;
        }

        @Override
        public final long storagePosition() {
            return this.storagePosition;
        }

        @Override
        public final long cachedDataLength() {
            return this.hasOnlySimpleReferencesLoaded() ? this.calculateSimpleReferenceCacheLength() : (long)this.length;
        }

        @Override
        public final boolean hasReferences() {
            return this.referenceCount != 0;
        }

        @Override
        public final long objectId() {
            return this.objectId;
        }

        final void touch() {
            this.lastTouched = (int)(System.currentTimeMillis() - TOUCHED_START_OFFSET >>> 8);
        }

        @Override
        public final long lastTouched() {
            return TOUCHED_START_OFFSET + ((long)this.lastTouched << 8);
        }

        @Override
        public final StorageLiveDataFile storageFile() {
            return this.typeInFile.file;
        }

        @Override
        public final boolean iterateReferenceIds(PersistenceObjectIdAcceptor referenceIdIterator) {
            if (!this.hasReferences()) {
                return false;
            }
            boolean requiredLoading = this.ensureCachedReferenceData();
            this.touch();
            this.typeInFile.type.iterateEntityReferenceIds(this, referenceIdIterator);
            return requiredLoading;
        }

        @Override
        public final long exportTo(AWritableFile file) {
            return this.typeInFile.file.copyTo(file, (long)this.storagePosition, (long)this.length);
        }

        @Override
        public final void copyCachedData(MemoryRangeReader entityDataCollector) {
            this.ensureCachedFullData();
            this.touch();
            entityDataCollector.readMemory(this.cacheAddress(), (long)this.length);
        }

        @Override
        public final long clearCache() {
            long currentDataLength = this.cachedDataLength();
            XMemory.free((long)this.cacheAddress());
            this.cacheAddress = 0L;
            this.onlyRefsCached = false;
            return currentDataLength;
        }

        public final String toString() {
            return this.objectId() + (this.isLive() ? " L" : "  ") + " GC[" + (this.isGcGray() ? (char)'G' : ' ') + (this.isGcBlack() ? (char)'B' : ' ') + "] [" + this.length + "]";
        }
    }
}

