/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.serializer.afs.types.AReadableFile;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.exceptions.StorageExceptionConsistency;
import org.eclipse.store.storage.exceptions.StorageExceptionIo;

public interface StorageDataFileItemIterator {
    default public void iterateStoredItems(AReadableFile file) {
        this.iterateStoredItems(file, 0L, file.size());
    }

    public void iterateStoredItems(AReadableFile var1, long var2, long var4);

    public static StorageDataFileItemIterator New(BufferProvider bufferProvider, ItemProcessor entityProcessor) {
        return new Default(bufferProvider, entityProcessor);
    }

    public static final class Default
    implements StorageDataFileItemIterator {
        private final BufferProvider bufferProvider;
        private final ItemProcessor itemProcessor;

        Default(BufferProvider bufferProvider, ItemProcessor itemProcessor) {
            this.bufferProvider = bufferProvider;
            this.itemProcessor = itemProcessor;
        }

        public static <P extends ItemProcessor> P processInputFile(AReadableFile file, P itemProcessor) throws IOException {
            return Default.processInputFile(file, BufferProvider.New(), itemProcessor, 0L, file.size());
        }

        public static <P extends ItemProcessor> P processInputFile(AReadableFile file, BufferProvider bufferProvider, P itemProcessor, long startPosition, long length) throws IOException {
            long actualFileLength = file.size();
            long boundPosition = startPosition + length;
            long currentFilePosition = startPosition;
            if (currentFilePosition < 0L || currentFilePosition > actualFileLength) {
                throw new IndexBoundsException(actualFileLength, currentFilePosition);
            }
            if (boundPosition < 0L || boundPosition > actualFileLength) {
                throw new IndexBoundsException(actualFileLength, boundPosition);
            }
            NextItemLength nextItemLength = new NextItemLength();
            ByteBuffer buffer = bufferProvider.provideInitialBuffer();
            try {
                while (currentFilePosition < boundPosition) {
                    if (currentFilePosition + (long)(buffer = bufferProvider.provideBuffer(buffer, nextItemLength.value)).limit() >= boundPosition) {
                        buffer.limit((int)(boundPosition - currentFilePosition));
                    }
                    file.readBytes(buffer, currentFilePosition, (long)buffer.limit());
                    long progress = Default.processBufferedEntities(XMemory.getDirectByteBufferAddress((ByteBuffer)buffer), buffer.limit(), nextItemLength, itemProcessor);
                    currentFilePosition += progress;
                }
            }
            catch (Exception e) {
                throw new StorageException("currentFilePosition = " + currentFilePosition + ". nextEntityLength = " + nextItemLength.value, e);
            }
            bufferProvider.cleanUp();
            return itemProcessor;
        }

        private static long processBufferedEntities(long startAddress, long bufferDataLength, NextItemLength nextItemLength, ItemProcessor entityProcessor) throws IOException {
            long bufferBound = startAddress + bufferDataLength;
            long entityStartBound = bufferBound - 8L;
            long address = startAddress;
            long itemLength = 0L;
            do {
                if ((itemLength = Binary.getEntityLengthRawValue((long)address)) == 0L) {
                    throw new StorageExceptionConsistency("Zero length data item.");
                }
                if (entityProcessor.accept(address, bufferBound - address)) continue;
                nextItemLength.value = Math.abs(itemLength);
                return address - startAddress;
            } while ((address += Math.abs(itemLength)) <= entityStartBound);
            nextItemLength.value = 0L;
            return address - startAddress;
        }

        @Override
        public final void iterateStoredItems(AReadableFile file, long startPosition, long length) {
            try {
                Default.processInputFile(file, this.bufferProvider, this.itemProcessor, startPosition, length);
            }
            catch (IOException e) {
                throw new StorageExceptionIo(e);
            }
        }

        static final class NextItemLength {
            long value;

            NextItemLength() {
            }
        }
    }

    @FunctionalInterface
    public static interface BufferProvider {
        default public ByteBuffer provideInitialBuffer() {
            return XMemory.allocateDirectNativeDefault();
        }

        public ByteBuffer provideBuffer(ByteBuffer var1, long var2);

        default public void cleanUp() {
        }

        public static BufferProvider New() {
            return BufferProvider.NewConstantSized(0);
        }

        public static BufferProvider NewConstantSized(int bufferCapacity) {
            return new ConstantSizedBufferProvider(Math.max(bufferCapacity, XMemory.defaultBufferSize()));
        }

        public static final class ConstantSizedBufferProvider
        implements BufferProvider {
            private final ByteBuffer buffer;

            ConstantSizedBufferProvider(int bufferCapacity) {
                this.buffer = XMemory.allocateDirectNative((int)bufferCapacity);
            }

            @Override
            public final ByteBuffer provideInitialBuffer() {
                return this.buffer;
            }

            @Override
            public final ByteBuffer provideBuffer(ByteBuffer byteBuffer, long nextEntityLength) {
                this.buffer.clear();
                if (nextEntityLength > (long)this.buffer.capacity()) {
                    this.buffer.limit(Binary.entityHeaderLength());
                }
                return this.buffer;
            }
        }
    }

    @FunctionalInterface
    public static interface ItemProcessor {
        public boolean accept(long var1, long var3);
    }
}

