/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.store.storage.types.StorageDataFileDissolvingEvaluator;
import org.eclipse.store.storage.types.StorageLiveDataFile;

public interface StorageDataFileEvaluator
extends StorageDataFileDissolvingEvaluator {
    @Override
    public boolean needsDissolving(StorageLiveDataFile var1);

    public boolean needsRetirement(long var1);

    public int fileMinimumSize();

    public int fileMaximumSize();

    public int transactionFileMaximumSize();

    public static StorageDataFileEvaluator New() {
        return StorageDataFileEvaluator.New(Defaults.defaultFileMinimumSize(), Defaults.defaultFileMaximumSize(), Defaults.defaultMinimumUseRatio(), Defaults.defaultResolveHeadfile(), Defaults.defaultTransactionFileMaximumSize());
    }

    public static StorageDataFileEvaluator New(double minimumUseRatio) {
        return StorageDataFileEvaluator.New(Defaults.defaultFileMinimumSize(), Defaults.defaultFileMaximumSize(), minimumUseRatio, Defaults.defaultResolveHeadfile(), Defaults.defaultTransactionFileMaximumSize());
    }

    public static StorageDataFileEvaluator New(int fileMinimumSize, int fileMaximumSize) {
        return StorageDataFileEvaluator.New(fileMinimumSize, fileMaximumSize, Defaults.defaultMinimumUseRatio(), Defaults.defaultResolveHeadfile(), Defaults.defaultTransactionFileMaximumSize());
    }

    public static StorageDataFileEvaluator New(int fileMinimumSize, int fileMaximumSize, double minimumUseRatio) {
        return StorageDataFileEvaluator.New(fileMinimumSize, fileMaximumSize, minimumUseRatio, Defaults.defaultResolveHeadfile(), Defaults.defaultTransactionFileMaximumSize());
    }

    public static StorageDataFileEvaluator New(int fileMinimumSize, int fileMaximumSize, double minimumUseRatio, boolean cleanUpHeadFile) {
        return StorageDataFileEvaluator.New(fileMinimumSize, fileMaximumSize, minimumUseRatio, cleanUpHeadFile, Defaults.defaultTransactionFileMaximumSize());
    }

    public static StorageDataFileEvaluator New(int fileMinimumSize, int fileMaximumSize, double minimumUseRatio, boolean cleanUpHeadFile, int transactionFileMaximumSize) {
        Validation.validateParameters(fileMinimumSize, fileMaximumSize, minimumUseRatio, transactionFileMaximumSize);
        return new Default(fileMinimumSize, fileMaximumSize, minimumUseRatio, cleanUpHeadFile, transactionFileMaximumSize);
    }

    public static final class Default
    implements StorageDataFileEvaluator {
        private final int fileMinimumSize;
        private final int fileMaximumSize;
        private final double minimumUseRatio;
        private final boolean cleanupHeadFile;
        private final int transactionFileMaximumSize;

        Default(int fileMinimumSize, int fileMaximumSize, double minimumUseRatio, boolean cleanupHeadFile, int transactionFileMaximumSize) {
            this.fileMinimumSize = fileMinimumSize;
            this.fileMaximumSize = fileMaximumSize;
            this.minimumUseRatio = minimumUseRatio;
            this.cleanupHeadFile = cleanupHeadFile;
            this.transactionFileMaximumSize = transactionFileMaximumSize;
        }

        @Override
        public final int fileMinimumSize() {
            return this.fileMinimumSize;
        }

        @Override
        public final int fileMaximumSize() {
            return this.fileMaximumSize;
        }

        public double minimumUseRatio() {
            return this.minimumUseRatio;
        }

        public boolean cleanupHeadFile() {
            return this.cleanupHeadFile;
        }

        @Override
        public final int transactionFileMaximumSize() {
            return this.transactionFileMaximumSize;
        }

        @Override
        public final boolean needsDissolving(StorageLiveDataFile storageFile) {
            if (!this.cleanupHeadFile && storageFile.isHeadFile()) {
                return false;
            }
            return this.isBelowMinimumSize(storageFile) && !storageFile.isHeadFile() || this.hasTooMuchGapSpace(storageFile) || this.isAboveMaximumSize(storageFile) && !this.isGaplessSingleEntityFile(storageFile);
        }

        private boolean isBelowMinimumSize(StorageLiveDataFile storageFile) {
            return storageFile.totalLength() < (long)this.fileMinimumSize();
        }

        private boolean hasTooMuchGapSpace(StorageLiveDataFile storageFile) {
            return storageFile.dataFillRatio() < this.minimumUseRatio;
        }

        private boolean isAboveMaximumSize(StorageLiveDataFile storageFile) {
            return storageFile.totalLength() > (long)this.fileMaximumSize();
        }

        private boolean isGaplessSingleEntityFile(StorageLiveDataFile storageFile) {
            return storageFile.hasSingleEntity() && storageFile.dataLength() == storageFile.totalLength();
        }

        @Override
        public final boolean needsRetirement(long fileTotalLength) {
            return fileTotalLength >= (long)this.fileMaximumSize;
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().blank().add("fileMinimumSize").tab().add('=').blank().add(this.fileMinimumSize).lf().blank().add("fileMaximumSize").tab().add('=').blank().add(this.fileMaximumSize).lf().blank().add("minimumUseRatio").tab().add('=').blank().add(this.minimumUseRatio).lf().blank().add("cleanupHeadFile").tab().add('=').blank().add(this.cleanupHeadFile).toString();
        }
    }

    public static interface Defaults {
        public static int defaultFileMinimumSize() {
            return 0x100000;
        }

        public static int defaultTransactionFileMaximumSize() {
            return 0x6400000;
        }

        public static int defaultFileMaximumSize() {
            return 0x800000;
        }

        public static double defaultMinimumUseRatio() {
            return 0.75;
        }

        public static boolean defaultResolveHeadfile() {
            return true;
        }
    }

    public static interface Validation {
        public static int minimumFileSize() {
            return 1024;
        }

        public static int maximumFileSize() {
            return Integer.MAX_VALUE;
        }

        public static int minimumTransactionLogFileSize() {
            return 1024;
        }

        public static int maximumTransactionLogFileSize() {
            return 0x40000000;
        }

        public static int minimumFileSizeRange() {
            return 1024;
        }

        public static double useRatioLowerBound() {
            return 0.0;
        }

        public static double useRatioMaximum() {
            return 1.0;
        }

        public static void validateParameters(int fileMinimumSize, int fileMaximumSize, double minimumUseRatio, int transactionFileMaximumSize) {
            if (fileMinimumSize < Validation.minimumFileSize() || fileMinimumSize > Validation.maximumFileSize()) {
                throw new IllegalArgumentException("Specified file minimum size of " + fileMinimumSize + " is not in the valid range of [" + Validation.minimumFileSize() + ", " + Validation.maximumFileSize() + "].");
            }
            if (fileMaximumSize < Validation.minimumFileSize() || fileMaximumSize > Validation.maximumFileSize()) {
                throw new IllegalArgumentException("Specified file maximum size of " + fileMaximumSize + " is not in the valid range of [" + Validation.minimumFileSize() + ", " + Validation.maximumFileSize() + "].");
            }
            if (fileMaximumSize - Validation.minimumFileSizeRange() < fileMinimumSize) {
                throw new IllegalArgumentException("For the specified file minimum size of " + fileMinimumSize + ", the specified file maximum size must at least be " + Validation.minimumFileSizeRange() + " higher (" + (fileMinimumSize + Validation.minimumFileSizeRange()) + " in total), but it is only " + fileMaximumSize + ".");
            }
            if (minimumUseRatio <= Validation.useRatioLowerBound() || minimumUseRatio > Validation.useRatioMaximum()) {
                throw new IllegalArgumentException("Specified minimum usage ratio of " + minimumUseRatio + " is not in the valid range of ]" + Validation.useRatioLowerBound() + ", " + Validation.useRatioMaximum() + "].");
            }
            if (transactionFileMaximumSize < Validation.minimumTransactionLogFileSize() || transactionFileMaximumSize > Validation.maximumTransactionLogFileSize()) {
                throw new IllegalArgumentException("Specified transaction file maximum size of " + transactionFileMaximumSize + " is not in the valid range of [" + Validation.minimumTransactionLogFileSize() + ", " + Validation.maximumTransactionLogFileSize() + "].");
            }
        }
    }
}

