/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.eclipse.serializer.afs.types.AFS;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.afs.types.AReadableFile;
import org.eclipse.serializer.afs.types.AWritableFile;
import org.eclipse.serializer.chars.EscapeHandler;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.chars.XCsvParserCharArray;
import org.eclipse.serializer.chars._charArrayRange;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.functional._charRangeProcedure;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.xcsv.XCsvConfiguration;
import org.eclipse.serializer.util.xcsv.XCsvRecordParserCharArray;
import org.eclipse.serializer.util.xcsv.XCsvRowCollector;
import org.eclipse.serializer.util.xcsv.XCsvSegmentsParser;
import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.types.StorageDataConverterCsvConfiguration;
import org.eclipse.store.storage.types.StorageEntityTypeConversionFileProvider;
import org.eclipse.store.storage.types.StorageEntityTypeExportFileProvider;

public interface StorageDataConverterTypeCsvToBinary<S> {
    public void convertCsv(S var1);

    default public <I extends Iterable<S>> void convertCsv(I sources) {
        sources.forEach(this::convertCsv);
    }

    public static StorageDataConverterTypeCsvToBinary<AFile> New(StorageDataConverterCsvConfiguration configuration, PersistenceTypeDictionary typeDictionary, StorageEntityTypeConversionFileProvider fileProvider) {
        return StorageDataConverterTypeCsvToBinary.New(configuration, typeDictionary, fileProvider, 0);
    }

    public static StorageDataConverterTypeCsvToBinary<AFile> New(StorageDataConverterCsvConfiguration configuration, PersistenceTypeDictionary typeDictionary, StorageEntityTypeConversionFileProvider fileProvider, int bufferSize) {
        return new Default((StorageDataConverterCsvConfiguration)X.notNull((Object)configuration), (PersistenceTypeDictionary)X.notNull((Object)typeDictionary), (StorageEntityTypeConversionFileProvider)X.notNull((Object)fileProvider), bufferSize);
    }

    public static final class Default
    implements StorageDataConverterTypeCsvToBinary<AFile>,
    XCsvSegmentsParser.Provider<_charArrayRange>,
    XCsvSegmentsParser<_charArrayRange>,
    XCsvRecordParserCharArray.Provider,
    XCsvRowCollector,
    XCsvRecordParserCharArray {
        static final int BIT_SHIFT_DIVIDE_NONE = 0;
        static final int BIT_SHIFT_DIVIDE_BY_2 = 1;
        static final int BIT_SHIFT_DIVIDE_BY_4 = 2;
        static final int BIT_SHIFT_DIVIDE_BY_8 = 3;
        static final int BIT_SHIFT_HEX_HIGH_BYTE = 4;
        static final int SIMPLE_CHAR_SKIP_LENGTH = 2;
        static final int ESCAPED_CHAR_SKIP_LENGTH = 3;
        static final int DELIMITED_CHAR_LENGTH = 3;
        static final int DELIMITED_ESCAPED_CHAR_LENGTH = 4;
        final StorageDataConverterCsvConfiguration configuration;
        final PersistenceTypeDictionary typeDictionary;
        final StorageEntityTypeConversionFileProvider fileProvider;
        final ByteBuffer byteBuffer;
        final long byteBufferStartAddress;
        final long byteBufferFlushBoundAddress;
        final int bufferSize;
        final EqConstHashTable<String, ValueHandler> simpleValueWriters;
        final EqConstHashTable<String, ValueHandler> theMappingNeverEnds;
        final char[] literalTrue;
        final char[] literalFalse;
        final char literalDelimiter;
        final char listStarter;
        final char listSeparator;
        final char listTerminator;
        final char escaper;
        final char terminator;
        final EscapeHandler escapeHandler;
        final ByteBuffer listHeaderUpdateBuffer;
        final long addressListHeaderUpdateBuffer;
        final ByteBuffer entityLengthUpdateBuffer;
        final long addressEntityLengthUpdateBuffer;
        final ValueHandler objectIdValueHandler;
        AFile sourceFile;
        AWritableFile targetFile;
        long targetFileActualLength;
        PersistenceTypeDefinition currentType;
        long currentTypeEntityInitLength;
        ValueHandler[] valueHandler;
        long currentBufferAddress;
        XCsvConfiguration actualCsvConfiguation;
        private static final int ASCII_OFFSET_HEX_TO_DEC_DIGIT = 48;
        private static final int ASCII_OFFSET_HEX_TO_DEC_CHAR = 55;

        Default(StorageDataConverterCsvConfiguration configuration, PersistenceTypeDictionary typeDictionary, StorageEntityTypeConversionFileProvider fileProvider, int bufferSize) {
            this.configuration = configuration;
            this.typeDictionary = typeDictionary;
            this.fileProvider = fileProvider;
            this.bufferSize = Math.max(bufferSize, 2 * XMemory.defaultBufferSize());
            this.byteBuffer = Default.createBuffer(this.bufferSize);
            this.byteBufferStartAddress = Default.address(this.byteBuffer);
            this.byteBufferFlushBoundAddress = this.byteBufferStartAddress + (long)XMemory.defaultBufferSize();
            this.simpleValueWriters = this.deriveSimpleValueWriters(configuration);
            this.theMappingNeverEnds = this.derivePrimitiveToArrayWriters(this.simpleValueWriters);
            this.literalTrue = XChars.readChars((String)configuration.literalBooleanTrue());
            this.literalFalse = XChars.readChars((String)configuration.literalBooleanFalse());
            this.literalDelimiter = configuration.csvConfiguration().literalDelimiter();
            this.listStarter = configuration.literalListStarter();
            this.listSeparator = configuration.literalListSeparator();
            this.listTerminator = configuration.literalListTerminator();
            this.terminator = configuration.csvConfiguration().terminator();
            this.escaper = configuration.csvConfiguration().escaper();
            this.escapeHandler = configuration.csvConfiguration().escapeHandler();
            this.listHeaderUpdateBuffer = Default.createBuffer((int)Binary.binaryListMinimumLength());
            this.addressListHeaderUpdateBuffer = Default.address(this.listHeaderUpdateBuffer);
            this.entityLengthUpdateBuffer = Default.createBuffer(Binary.lengthLength());
            this.addressEntityLengthUpdateBuffer = Default.address(this.entityLengthUpdateBuffer);
            this.objectIdValueHandler = (ValueHandler)this.simpleValueWriters.get((Object)Long.TYPE.getName());
            this.currentBufferAddress = this.byteBufferStartAddress;
        }

        private static ByteBuffer createBuffer(int capacity) {
            return XMemory.allocateDirectNative((int)capacity);
        }

        private static long address(ByteBuffer dbb) {
            return XMemory.getDirectByteBufferAddress((ByteBuffer)dbb);
        }

        final EqConstHashTable<String, ValueHandler> derivePrimitiveToArrayWriters(EqConstHashTable<String, ValueHandler> valueWriters) {
            return EqConstHashTable.New((KeyValue[])new KeyValue[]{X.KeyValue((Object)Byte.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)byte[].class.getName()))), X.KeyValue((Object)Boolean.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)boolean[].class.getName()))), X.KeyValue((Object)Short.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)short[].class.getName()))), X.KeyValue((Object)Character.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)char[].class.getName()))), X.KeyValue((Object)Integer.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)int[].class.getName()))), X.KeyValue((Object)Float.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)float[].class.getName()))), X.KeyValue((Object)Long.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)long[].class.getName()))), X.KeyValue((Object)Double.TYPE.getName(), (Object)((ValueHandler)valueWriters.get((Object)double[].class.getName())))});
        }

        final EqConstHashTable<String, ValueHandler> deriveSimpleValueWriters(StorageDataConverterCsvConfiguration configuration) {
            return EqConstHashTable.New((KeyValue[])new KeyValue[]{X.KeyValue((Object)Byte.TYPE.getName(), this::parse_byte), X.KeyValue((Object)Boolean.TYPE.getName(), this::parse_boolean), X.KeyValue((Object)Short.TYPE.getName(), this::parse_short), X.KeyValue((Object)Character.TYPE.getName(), this::parse_char), X.KeyValue((Object)Integer.TYPE.getName(), this::parse_int), X.KeyValue((Object)Float.TYPE.getName(), this::parse_float), X.KeyValue((Object)Long.TYPE.getName(), this::parse_long), X.KeyValue((Object)Double.TYPE.getName(), this::parse_double), X.KeyValue((Object)byte[].class.getName(), this::parseArray_byte), X.KeyValue((Object)boolean[].class.getName(), this::parseArray_boolean), X.KeyValue((Object)short[].class.getName(), this::parseArray_short), X.KeyValue((Object)char[].class.getName(), this::parseChars), X.KeyValue((Object)int[].class.getName(), this::parseArray_int), X.KeyValue((Object)float[].class.getName(), this::parseArray_float), X.KeyValue((Object)long[].class.getName(), this::parseArray_long), X.KeyValue((Object)double[].class.getName(), this::parseArray_double), X.KeyValue((Object)PersistenceTypeDictionary.Symbols.typeChars(), this::parseChars), X.KeyValue((Object)PersistenceTypeDictionary.Symbols.typeBytes(), this::parseBytes)});
        }

        final int parse_byte(char[] data, int offset, int bound, char separator, char terminator) {
            int i;
            for (i = offset; i < bound && data[i] != separator && data[i] != terminator; ++i) {
            }
            int j = i - 1;
            while (data[j] <= ' ') {
                --j;
            }
            this.write_byte(XChars.parse_byteDecimal((char[])data, (int)offset, (int)(j - offset + 1)));
            return i;
        }

        final int parse_boolean(char[] data, int offset, int bound, char separator, char terminator) {
            int i;
            for (i = offset; i < bound && data[i] != separator && data[i] != terminator; ++i) {
            }
            int j = i - 1;
            while (data[j] <= ' ') {
                --j;
            }
            int literalLength = j - offset + 1;
            if (literalLength == this.literalTrue.length && XChars.equals((char[])data, (int)offset, (char[])this.literalTrue, (int)0, (int)this.literalTrue.length)) {
                this.write_boolean(true);
                return i;
            }
            if (literalLength == this.literalFalse.length && XChars.equals((char[])data, (int)offset, (char[])this.literalFalse, (int)0, (int)this.literalFalse.length)) {
                this.write_boolean(false);
                return i;
            }
            throw new StorageException("Invalid boolean literal: " + String.valueOf(data, offset, literalLength));
        }

        final int parse_short(char[] data, int offset, int bound, char separator, char terminator) {
            int i;
            for (i = offset; i < bound && data[i] != separator && data[i] != terminator; ++i) {
            }
            int j = i - 1;
            while (data[j] <= ' ') {
                --j;
            }
            this.write_short(XChars.parse_shortDecimal((char[])data, (int)offset, (int)(j - offset + 1)));
            return i;
        }

        final int parse_char(char[] data, int offset, int bound, char separator, char terminator) {
            return bound - offset >= 4 ? this.parse_charNormal(data, offset) : this.parse_charTrailing(data, offset, bound - offset);
        }

        final int parse_charNormal(char[] data, int offset) {
            if (data[offset] != this.literalDelimiter) {
                throw new StorageException("Invalid character literal at " + offset);
            }
            if (data[offset + 1] == this.escaper) {
                if (data[offset + 3] != this.literalDelimiter) {
                    throw new StorageException("Unclosed character literal at " + (offset + 3));
                }
                this.write_char(this.escapeHandler.unescape(data[offset + 2]));
                return offset + 4;
            }
            if (data[offset + 2] != this.literalDelimiter) {
                throw new StorageException("Unclosed character literal at " + (offset + 2));
            }
            this.write_char(data[offset + 1]);
            return offset + 3;
        }

        final int parse_charTrailing(char[] data, int offset, int length) {
            if (length != 3 || data[offset] != this.literalDelimiter || data[offset + 1] == this.escaper || data[offset + 2] != this.literalDelimiter) {
                throw new StorageException("Invalid character literal at " + offset);
            }
            this.write_char(data[offset + 1]);
            return offset + 3;
        }

        final int parse_int(char[] data, int offset, int bound, char separator, char terminator) {
            int i;
            for (i = offset; i < bound && data[i] != separator && data[i] != terminator; ++i) {
            }
            int j = i - 1;
            while (data[j] <= ' ') {
                --j;
            }
            this.write_int(XChars.parse_intLiteral((char[])data, (int)offset, (int)(j - offset + 1)));
            return i;
        }

        final int parse_float(char[] data, int offset, int bound, char separator, char terminator) {
            int i;
            for (i = offset; i < bound && data[i] != separator && data[i] != terminator; ++i) {
            }
            int j = i - 1;
            while (data[j] <= ' ') {
                --j;
            }
            this.write_float(XChars.parse_float((char[])data, (int)offset, (int)(j - offset + 1)));
            return i;
        }

        final int parse_long(char[] data, int offset, int bound, char separator, char terminator) {
            int i;
            for (i = offset; i < bound && data[i] != separator && data[i] != terminator; ++i) {
            }
            int j = i - 1;
            while (data[j] <= ' ') {
                --j;
            }
            this.write_long(XChars.parse_longDecimal((char[])data, (int)offset, (int)(j - offset + 1)));
            return i;
        }

        final int parse_double(char[] data, int offset, int bound, char separator, char terminator) {
            int i;
            for (i = offset; i < bound && data[i] != separator && data[i] != terminator; ++i) {
            }
            int j = i - 1;
            while (data[j] <= ' ') {
                --j;
            }
            this.write_double(XChars.parse_double((char[])data, (int)offset, (int)(j - offset + 1)));
            return i;
        }

        final int parseChars(char[] data, int offset, int bound, char separator, char terminator) {
            if (data[offset] != this.literalDelimiter) {
                throw new StorageException("Missing literal delimiter " + this.listStarter + " at offset " + offset);
            }
            long currentFileOffset = this.writeListHeader();
            int lastCharIndex = bound - 1;
            char literalDelimiter = this.literalDelimiter;
            char escaper = this.escaper;
            EscapeHandler escapeHandler = this.escapeHandler;
            int i = offset;
            while (true) {
                if (++i >= bound) {
                    throw new StorageException("incomplete trailing characters at offset " + bound);
                }
                if (data[i] == literalDelimiter) break;
                if (data[i] == escaper) {
                    if (i == lastCharIndex) {
                        throw new StorageException("incomplete characters literal at offset " + bound);
                    }
                    this.write_char(escapeHandler.unescape(data[++i]));
                    continue;
                }
                this.write_char(data[i]);
            }
            this.retroUpdateListHeader(currentFileOffset, 1);
            return i + 1;
        }

        final int parseBytes(char[] data, int offset, int bound, char separator, char terminator) {
            long currentFileOffset = this.writeListHeader();
            int lastCharIndex = bound - 1;
            int i = offset;
            while (i < bound && data[i] != separator && data[i] != terminator) {
                if (data[i] <= ' ') {
                    ++i;
                    continue;
                }
                if (i >= lastCharIndex || data[i + 1] == separator || data[i + 1] == terminator || data[i + 1] <= ' ') {
                    throw new StorageException("Incomplete hexadecimal string at offset " + i);
                }
                this.write_byte((byte)((Default.toValue(data[i]) << 4) + Default.toValue(data[i + 1])));
                i += 2;
            }
            this.retroUpdateListHeader(currentFileOffset, 0);
            return i;
        }

        static final int toValue(char hexDigit) {
            if (hexDigit < ':' && hexDigit >= '0') {
                return hexDigit - 48;
            }
            if (hexDigit < 'G' && hexDigit >= 'A') {
                return hexDigit - 55;
            }
            throw new StorageException("Invalid hexadecimal character: " + hexDigit);
        }

        final int parseArray_byte(char[] data, int offset, int bound, char separator, char terminator) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            while (data[i = Default.seekSimpleLiteralStart(data, i, bound, listSeparator)] != listTerminator) {
                int currentElementStart = i;
                i = Default.seekSimpleLiteralEnd(data, i, bound, listSeparator, listTerminator);
                this.write_byte(XChars.parse_byteDecimal((char[])data, (int)currentElementStart, (int)(i - currentElementStart)));
                i = Default.seekListElementCompletion(data, i, bound, listSeparator, listTerminator);
            }
            this.retroUpdateListHeader(currentFileOffset, 0);
            return Default.seekValueTerminator(data, i + 1, bound, separator, terminator);
        }

        final int parseArray_boolean(char[] data, int offset, int bound, char separator, char terminator) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            char[] literalTrue = this.literalTrue;
            char[] literalFalse = this.literalFalse;
            int lengthTrue = literalTrue.length;
            int lengthFalse = literalFalse.length;
            int i = offset + 1;
            long elementCount = 0L;
            while (data[i = Default.seekSimpleLiteralStart(data, i, bound, listSeparator)] != listTerminator) {
                int elementStart = i;
                if ((i = Default.seekSimpleLiteralEnd(data, i, bound, listSeparator, listTerminator)) - elementStart == lengthTrue && XChars.equals((char[])data, (int)elementStart, (char[])literalTrue, (int)0, (int)lengthTrue)) {
                    this.write_boolean(true);
                } else if (i - elementStart == lengthFalse && XChars.equals((char[])data, (int)elementStart, (char[])literalFalse, (int)0, (int)lengthFalse)) {
                    this.write_boolean(false);
                } else {
                    throw new StorageException("Invalid boolean literal at offset " + elementStart);
                }
                ++elementCount;
                i = Default.seekListElementCompletion(data, i, bound, listSeparator, listTerminator);
            }
            this.retroUpdateListHeader(currentFileOffset, Binary.toBinaryListTotalByteLength((long)(elementCount * (long)XMemory.byteSize_boolean())), elementCount);
            return Default.seekValueTerminator(data, i + 1, bound, separator, terminator);
        }

        final int parseArray_short(char[] data, int offset, int bound, char separator, char terminator) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            while (data[i = Default.seekSimpleLiteralStart(data, i, bound, listSeparator)] != listTerminator) {
                int currentElementStart = i;
                i = Default.seekSimpleLiteralEnd(data, i, bound, listSeparator, listTerminator);
                this.write_short(XChars.parse_shortDecimal((char[])data, (int)currentElementStart, (int)(i - currentElementStart)));
                i = Default.seekListElementCompletion(data, i, bound, listSeparator, listTerminator);
            }
            this.retroUpdateListHeader(currentFileOffset, 1);
            return Default.seekValueTerminator(data, i + 1, bound, separator, terminator);
        }

        final int parseArray_int(char[] data, int offset, int bound, char separator, char terminator) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            while (data[i = Default.seekSimpleLiteralStart(data, i, bound, listSeparator)] != listTerminator) {
                int currentElementStart = i;
                i = Default.seekSimpleLiteralEnd(data, i, bound, listSeparator, listTerminator);
                this.write_int(XChars.parse_intLiteral((char[])data, (int)currentElementStart, (int)(i - currentElementStart)));
                i = Default.seekListElementCompletion(data, i, bound, listSeparator, listTerminator);
            }
            this.retroUpdateListHeader(currentFileOffset, 2);
            return Default.seekValueTerminator(data, i + 1, bound, separator, terminator);
        }

        final int parseArray_float(char[] data, int offset, int bound, char separator, char terminator) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            while (data[i = Default.seekSimpleLiteralStart(data, i, bound, listSeparator)] != listTerminator) {
                int currentElementStart = i;
                i = Default.seekSimpleLiteralEnd(data, i, bound, listSeparator, listTerminator);
                this.write_float(XChars.parse_float((char[])data, (int)currentElementStart, (int)(i - currentElementStart)));
                i = Default.seekListElementCompletion(data, i, bound, listSeparator, listTerminator);
            }
            this.retroUpdateListHeader(currentFileOffset, 2);
            return Default.seekValueTerminator(data, i + 1, bound, separator, terminator);
        }

        final int parseArray_long(char[] data, int offset, int bound, char separator, char terminator) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            while (data[i = Default.seekSimpleLiteralStart(data, i, bound, listSeparator)] != listTerminator) {
                int currentElementStart = i;
                i = Default.seekSimpleLiteralEnd(data, i, bound, listSeparator, listTerminator);
                this.write_long(XChars.parse_longDecimal((char[])data, (int)currentElementStart, (int)(i - currentElementStart)));
                i = Default.seekListElementCompletion(data, i, bound, listSeparator, listTerminator);
            }
            this.retroUpdateListHeader(currentFileOffset, 3);
            return Default.seekValueTerminator(data, i + 1, bound, separator, terminator);
        }

        final int parseArray_double(char[] data, int offset, int bound, char separator, char terminator) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            while (data[i = Default.seekSimpleLiteralStart(data, i, bound, separator)] != listTerminator) {
                int currentElementStart = i;
                i = Default.seekSimpleLiteralEnd(data, i, bound, listSeparator, listTerminator);
                this.write_double(XChars.parse_double((char[])data, (int)currentElementStart, (int)(i - currentElementStart)));
                i = Default.seekListElementCompletion(data, i, bound, listSeparator, listTerminator);
            }
            this.retroUpdateListHeader(currentFileOffset, 3);
            return Default.seekValueTerminator(data, i + 1, bound, separator, terminator);
        }

        static final void validateListStart(char[] data, int offset, char listStarter) {
            if (data[offset] != listStarter) {
                throw new StorageException("Missing list starter character " + listStarter + " at offset " + offset);
            }
        }

        final void beginEntity() {
            this.write_long(this.currentTypeEntityInitLength);
            this.write_long(this.currentType.typeId());
        }

        private long writeListHeader() {
            long currentFileOffset = this.getTargetFileVirtualLength();
            this.checkForFlush();
            XMemory.set_long((long)this.currentBufferAddress, (long)0L);
            XMemory.set_long((long)(this.currentBufferAddress + (long)XMemory.byteSize_long()), (long)0L);
            this.currentBufferAddress += (long)(2 * XMemory.byteSize_long());
            return currentFileOffset;
        }

        private void retroUpdateListHeader(long currentFileOffset, int bitDivisor) {
            long binaryLength = this.getTargetFileVirtualLength() - currentFileOffset;
            this.retroUpdateListHeader(currentFileOffset, binaryLength, Binary.toBinaryListContentByteLength((long)binaryLength) >> bitDivisor);
        }

        static final int seekListElementCompletion(char[] data, int index, int bound, char separator, char terminator) {
            int i = index;
            do {
                if (data[i] == separator) {
                    return i + 1;
                }
                if (data[i] == terminator) {
                    return i;
                }
                if (data[i] <= ' ') continue;
                throw new StorageException("incomplete missing separator at offset " + i);
            } while (++i < bound);
            throw new StorageException("incomplete trailing list at offset " + bound);
        }

        static final int seekValueTerminator(char[] data, int index, int bound, char separator, char terminator) {
            int i;
            for (i = index; i < bound && data[i] != separator && data[i] != terminator; ++i) {
                if (data[i] <= ' ') continue;
                throw new StorageException("missing value separator at offset " + i);
            }
            return i;
        }

        static final int seekSimpleLiteralStart(char[] data, int index, int bound, char separator) {
            int i;
            block2: {
                i = index;
                do {
                    if (data[i] == separator) {
                        throw new StorageException("missing list element at offset " + i);
                    }
                    if (data[i] > ' ') break block2;
                } while (++i < bound);
                throw new StorageException("incomplete trailing list at offset " + bound);
            }
            return i;
        }

        static final int seekSimpleLiteralEnd(char[] data, int index, int bound, char separator, char terminator) {
            int i = index;
            while (data[i] != separator && data[i] != terminator && data[i] > ' ') {
                if (++i < bound) continue;
                throw new StorageException("Incomplete trailing list at offset " + bound);
            }
            return i;
        }

        private void setTargetFile() {
            this.targetFile = this.fileProvider.provideConversionFile(this.currentType, this.sourceFile);
            this.targetFileActualLength = this.targetFile.size();
        }

        private void setSourceFile(AFile file) {
            this.flushCloseClear();
            this.sourceFile = file;
        }

        final void parseCurrentFile() {
            char[] input = AFS.readString((AFile)this.sourceFile, (Charset)XChars.utf8()).toCharArray();
            XCsvParserCharArray parser = XCsvParserCharArray.New();
            parser.parseCsvData(this.configuration.csvConfiguration(), (Object)_charArrayRange.New((char[])input), (XCsvSegmentsParser.Provider)this, (XCsvRowCollector)this);
        }

        final void flushCloseClear() {
            Throwable suppressed = null;
            try {
                this.flushBuffer();
                this.closeAndClear(suppressed);
            }
            catch (Throwable t) {
                try {
                    suppressed = t;
                    throw t;
                }
                catch (Throwable throwable) {
                    this.closeAndClear(suppressed);
                    throw throwable;
                }
            }
        }

        final void closeAndClear(Throwable suppressed) {
            try {
                AFS.close((AReadableFile)this.targetFile, (Throwable)suppressed);
            }
            finally {
                this.sourceFile = null;
                this.targetFile = null;
                this.actualCsvConfiguation = null;
            }
        }

        final void validateTypeNames(XGettingList<String> dataColumntypes) {
            XGettingEnum members = this.currentType.instanceMembers();
            if (members.size() != dataColumntypes.size()) {
                throw new StorageException("Count mismatch between data column count (" + dataColumntypes.size() + ") and field count (" + members.size() + ") of type " + this.currentType.typeName());
            }
            String referenceTypeName = this.configuration.referenceTypeName();
            Iterator memberIterator = members.iterator();
            for (String columnTypeName : dataColumntypes) {
                PersistenceTypeDescriptionMember member = (PersistenceTypeDescriptionMember)memberIterator.next();
                if (member.isReference()) {
                    if (referenceTypeName.equals(columnTypeName)) continue;
                    throw new StorageException("CSV reference column type mismatch: " + columnTypeName + " != " + member.typeName());
                }
                String fieldTypeName = this.configuration.resolveActualTypeName(columnTypeName);
                if (fieldTypeName.equals(member.typeName())) continue;
                throw new StorageException("CSV non-reference column type mismatch: " + fieldTypeName + " != " + member.typeName());
            }
        }

        final void deriveValueHandlers() {
            XGettingEnum members = this.currentType.instanceMembers();
            ValueHandler[] valueHandlers = new ValueHandler[X.checkArrayRange((long)members.size()) + 1];
            valueHandlers[0] = this.objectIdValueHandler;
            int i = 1;
            boolean hasVariableLength = false;
            long entityBaseLength = Binary.entityHeaderLength();
            for (PersistenceTypeDescriptionMember member : members) {
                if (member.isFixedLength()) {
                    entityBaseLength += member.persistentMinimumLength();
                } else {
                    hasVariableLength = true;
                }
                valueHandlers[i++] = this.deriveValueWriter(member);
            }
            this.valueHandler = valueHandlers;
            this.currentTypeEntityInitLength = hasVariableLength ? 0L : entityBaseLength;
        }

        final ValueHandler deriveValueWriter(PersistenceTypeDescriptionMember member) {
            String typeName = member.typeName();
            ValueHandler valueWriter = (ValueHandler)this.simpleValueWriters.get((Object)typeName);
            if (valueWriter != null) {
                return valueWriter;
            }
            if (member.isReference()) {
                return this.objectIdValueHandler;
            }
            if (!(member instanceof PersistenceTypeDescriptionMemberFieldGenericComplex)) {
                throw new StorageException("Unhandled non-complex persistence field type: " + typeName);
            }
            XGettingSequence members = ((PersistenceTypeDescriptionMemberFieldGenericComplex)member).members();
            if (members.size() == 1L) {
                PersistenceTypeDescriptionMemberFieldGeneric singletonField = (PersistenceTypeDescriptionMemberFieldGeneric)members.first();
                if (singletonField.isReference()) {
                    return (ValueHandler)this.simpleValueWriters.get((Object)long[].class.getName());
                }
                ValueHandler primitiveArrayHandler = (ValueHandler)this.theMappingNeverEnds.get((Object)singletonField.typeName());
                if (primitiveArrayHandler != null) {
                    return primitiveArrayHandler;
                }
                return new NestedValueHandler(this.deriveValueWriter((PersistenceTypeDescriptionMember)singletonField));
            }
            return this.deriveComplexValueHandlerMulti((XGettingSequence<PersistenceTypeDescriptionMemberFieldGeneric>)members);
        }

        final ValueHandler deriveComplexValueHandlerMulti(XGettingSequence<PersistenceTypeDescriptionMemberFieldGeneric> members) {
            ValueHandler[] valueHandlers = new ValueHandler[X.checkArrayRange((long)members.size())];
            int i = 0;
            for (PersistenceTypeDescriptionMemberFieldGeneric member : members) {
                valueHandlers[i++] = this.deriveValueWriter((PersistenceTypeDescriptionMember)member);
            }
            return new NestedValueHandlers(valueHandlers);
        }

        final int parseComplexListSingleField(char[] data, int offset, int bound, char separator, char terminator, ValueHandler valueHandler) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            long elementCount = 0L;
            block0: while (true) {
                if (i >= bound) {
                    throw new StorageException("Incomplete complex list at offset " + bound);
                }
                if (data[i] == listTerminator) break;
                if (data[i] <= ' ') {
                    ++i;
                    continue;
                }
                i = valueHandler.handleValue(data, i, bound, listSeparator, listTerminator);
                ++elementCount;
                while (true) {
                    if (i >= bound) {
                        throw new StorageException("Incomplete complex list at offset " + bound);
                    }
                    if (data[i] <= ' ') {
                        ++i;
                        continue;
                    }
                    if (data[i] == listTerminator) continue block0;
                    if (data[i] == listSeparator) break;
                }
                ++i;
            }
            this.retroUpdateListHeader(currentFileOffset, this.getTargetFileVirtualLength() - currentFileOffset, elementCount);
            return i;
        }

        final int parseComplexListMulti(char[] data, int offset, int bound, char separator, char terminator, ValueHandler[] valueHandlers) {
            Default.validateListStart(data, offset, this.listStarter);
            long currentFileOffset = this.writeListHeader();
            int handlerIndexBound = valueHandlers.length;
            char listStarter = this.listStarter;
            char listSeparator = this.listSeparator;
            char listTerminator = this.listTerminator;
            int i = offset + 1;
            long elementCount = 0L;
            block0: while (true) {
                if (i >= bound) {
                    throw new StorageException("Incomplete complex list at offset " + bound);
                }
                if (data[i] == listTerminator) break;
                if (data[i] <= ' ') {
                    ++i;
                    continue;
                }
                if (data[i] != listStarter) {
                    throw new StorageException("Missing list starter character " + listStarter + " at offset " + i);
                }
                ++i;
                for (int h = 0; h < handlerIndexBound; ++h) {
                    if (i >= bound) {
                        throw new StorageException("Incomplete complex list at offset " + bound);
                    }
                    if (data[i] == listTerminator) {
                        throw new StorageException("Incomplete complex list at offset " + i);
                    }
                    if (data[i] == listStarter) {
                        throw new StorageException("Missing complex list element at offset " + i);
                    }
                    if (data[i] <= ' ') {
                        ++i;
                        continue;
                    }
                    i = valueHandlers[h].handleValue(data, i, bound, listSeparator, listTerminator);
                    ++i;
                }
                ++elementCount;
                while (true) {
                    if (i >= bound) {
                        throw new StorageException("Incomplete complex list at offset " + bound);
                    }
                    if (data[i] <= ' ') {
                        ++i;
                        continue;
                    }
                    if (data[i] == listTerminator) continue block0;
                    if (data[i] == listSeparator) break;
                }
                ++i;
            }
            this.retroUpdateListHeader(currentFileOffset, this.getTargetFileVirtualLength() - currentFileOffset, elementCount);
            return i;
        }

        final void retroUpdateEntityLength(long filePosition, long entityTotalLength) {
            if (filePosition - this.targetFileActualLength >= 0L) {
                XMemory.set_long((long)(this.byteBufferStartAddress + filePosition - this.targetFileActualLength), (long)entityTotalLength);
            } else {
                XMemory.set_long((long)this.addressEntityLengthUpdateBuffer, (long)entityTotalLength);
                this.writeBuffer(this.entityLengthUpdateBuffer, filePosition);
            }
        }

        final void retroUpdateListHeader(long filePosition, long length, long elementCount) {
            if (filePosition - this.targetFileActualLength >= 0L) {
                long offset = filePosition - this.targetFileActualLength;
                XMemory.set_long((long)(this.byteBufferStartAddress + offset), (long)length);
                XMemory.set_long((long)(this.byteBufferStartAddress + offset + (long)XMemory.byteSize_long()), (long)elementCount);
            } else {
                XMemory.set_long((long)this.addressListHeaderUpdateBuffer, (long)length);
                XMemory.set_long((long)(this.addressListHeaderUpdateBuffer + (long)XMemory.byteSize_long()), (long)elementCount);
                this.writeBuffer(this.listHeaderUpdateBuffer, filePosition);
            }
        }

        final void writeBuffer(ByteBuffer byteBuffer, long filePosition) {
            try {
                this.targetFile.writeBytes(byteBuffer);
            }
            catch (Exception e) {
                AFS.close((AReadableFile)this.targetFile, (Throwable)e);
                throw new StorageException(e);
            }
            finally {
                byteBuffer.clear();
            }
        }

        final void flushBuffer() {
            if (this.currentBufferAddress == this.byteBufferStartAddress) {
                return;
            }
            this.byteBuffer.limit((int)(this.currentBufferAddress - this.byteBufferStartAddress));
            try {
                this.targetFile.writeBytes(this.byteBuffer);
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
            finally {
                this.targetFileActualLength += (long)this.byteBuffer.limit();
                this.byteBuffer.clear();
                this.currentBufferAddress = this.byteBufferStartAddress;
            }
        }

        final void checkForFlush() {
            if (this.currentBufferAddress < this.byteBufferFlushBoundAddress) {
                return;
            }
            this.flushBuffer();
        }

        final long getTargetFileVirtualLength() {
            return this.targetFileActualLength + this.currentBufferAddress - this.byteBufferStartAddress;
        }

        final void write_byte(byte value) {
            this.checkForFlush();
            XMemory.set_byte((long)this.currentBufferAddress, (byte)value);
            this.currentBufferAddress += (long)XMemory.byteSize_byte();
        }

        final void write_boolean(boolean value) {
            this.checkForFlush();
            XMemory.set_boolean((long)this.currentBufferAddress, (boolean)value);
            this.currentBufferAddress += (long)XMemory.byteSize_boolean();
        }

        final void write_short(short value) {
            this.checkForFlush();
            XMemory.set_short((long)this.currentBufferAddress, (short)value);
            this.currentBufferAddress += (long)XMemory.byteSize_short();
        }

        final void write_char(char value) {
            this.checkForFlush();
            XMemory.set_char((long)this.currentBufferAddress, (char)value);
            this.currentBufferAddress += (long)XMemory.byteSize_char();
        }

        final void write_int(int value) {
            this.checkForFlush();
            XMemory.set_int((long)this.currentBufferAddress, (int)value);
            this.currentBufferAddress += (long)XMemory.byteSize_int();
        }

        final void write_float(float value) {
            this.checkForFlush();
            XMemory.set_float((long)this.currentBufferAddress, (float)value);
            this.currentBufferAddress += 4L;
        }

        final void write_long(long value) {
            this.checkForFlush();
            XMemory.set_long((long)this.currentBufferAddress, (long)value);
            this.currentBufferAddress += (long)XMemory.byteSize_long();
        }

        final void write_double(double value) {
            this.checkForFlush();
            XMemory.set_double((long)this.currentBufferAddress, (double)value);
            this.currentBufferAddress += (long)XMemory.byteSize_double();
        }

        @Override
        public void convertCsv(AFile file) {
            this.setSourceFile(file);
            this.parseCurrentFile();
            this.flushCloseClear();
        }

        static final long getTypeIdFromFileName(AFile file) {
            String fileName = file.name();
            long typeId = StorageEntityTypeExportFileProvider.getTypeIdFromUniqueTypeFileName(fileName);
            return typeId;
        }

        public void beginTable(String tableName, XGettingSequence<String> columnNames, XGettingList<String> columnTypes) {
            long typeId = Default.getTypeIdFromFileName(this.sourceFile);
            this.currentType = this.typeDictionary.lookupTypeById(typeId);
            if (this.currentType == null) {
                throw new StorageException("Type not found: " + this.sourceFile.identifier());
            }
            String firstColumnName = (String)columnNames.first();
            if (!this.configuration.objectIdColumnName().equals(firstColumnName)) {
                throw new StorageException("First column (" + firstColumnName + ") is not " + this.configuration.objectIdColumnName());
            }
            this.validateTypeNames((XGettingList<String>)BulkList.New(columnTypes).removeRange(0L, 1L));
            this.deriveValueHandlers();
            this.setTargetFile();
        }

        public void accept(char[] data, int offset, int length) {
        }

        public final void completeRow() {
        }

        public final void completeTable() {
            this.flushBuffer();
        }

        public XCsvSegmentsParser<_charArrayRange> provideSegmentsParser(XCsvConfiguration config, XCsvRowCollector rowAggregator) {
            this.actualCsvConfiguation = config;
            return this;
        }

        public void parseSegments(_charArrayRange input) {
            XCsvParserCharArray.parseSegments((char[])input.array(), (int)input.start(), (int)input.bound(), (VarString)VarString.New(), (XCsvConfiguration)this.actualCsvConfiguation, (XCsvRowCollector)this, (XCsvRecordParserCharArray.Provider)this);
        }

        public XCsvRecordParserCharArray provideRecordParser() {
            return this;
        }

        public int parseRecord(char[] input, int iStart, int iBound, char valueSeparator, char delimiter, char escaper, char lineSeparator, char terminator, XCsvConfiguration config, VarString literalBuilder, EscapeHandler escapeHandler, _charRangeProcedure valueCollector) {
            ValueHandler[] valueHandlers = this.valueHandler;
            int handlerCount = valueHandlers.length;
            long entityFilePosition = this.getTargetFileVirtualLength();
            this.beginEntity();
            int i = iStart;
            for (int h = 0; h < handlerCount; ++h) {
                if (i == iBound) {
                    throw new StorageException("Incomplete record at index " + i);
                }
                if (input[i] == valueSeparator || input[i] == lineSeparator || input[i] == terminator) {
                    throw new StorageException("Missing value at index " + i);
                }
                if (input[i] <= ' ') {
                    ++i;
                    continue;
                }
                if ((i = valueHandlers[h].handleValue(input, i, iBound, valueSeparator, lineSeparator)) >= iBound) {
                    if (h >= handlerCount - 1) break;
                    throw new StorageException("Missing record value at index " + i);
                }
                ++i;
            }
            if (this.currentTypeEntityInitLength == 0L) {
                this.retroUpdateEntityLength(entityFilePosition, this.getTargetFileVirtualLength() - entityFilePosition);
            }
            return i;
        }

        final class NestedValueHandlers
        implements ValueHandler {
            final ValueHandler[] valueHandlers;

            NestedValueHandlers(ValueHandler[] valueHandlers) {
                this.valueHandlers = valueHandlers;
            }

            @Override
            public int handleValue(char[] data, int offset, int bound, char separator, char terminator) {
                return Default.this.parseComplexListMulti(data, offset, bound, separator, terminator, this.valueHandlers);
            }
        }

        final class NestedValueHandler
        implements ValueHandler {
            final ValueHandler valueHandler;

            NestedValueHandler(ValueHandler valueHandler) {
                this.valueHandler = valueHandler;
            }

            @Override
            public int handleValue(char[] data, int offset, int bound, char separator, char terminator) {
                return Default.this.parseComplexListSingleField(data, offset, bound, separator, terminator, this.valueHandler);
            }
        }
    }

    public static interface ValueHandler {
        public int handleValue(char[] var1, int var2, int var3, char var4, char var5);
    }
}

