/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.util.function.Consumer;
import org.eclipse.store.storage.types.StorageChannelImportEntity;
import org.eclipse.store.storage.types.StorageEntityType;

public interface StorageChannelImportBatch {
    public long batchOffset();

    public long batchLength();

    public void iterateEntities(Consumer<? super StorageChannelImportEntity> var1);

    public StorageChannelImportEntity first();

    public static class Default
    extends StorageChannelImportEntity.Default
    implements StorageChannelImportBatch {
        long batchOffset;
        long batchLength;
        Default batchNext;

        Default() {
            super(0, 0L, null);
        }

        Default(long batchOffset, int entityLength, long objectId, StorageEntityType.Default type) {
            super(entityLength, objectId, type);
            this.batchOffset = batchOffset;
            this.batchLength = entityLength;
        }

        @Override
        public long batchOffset() {
            return this.batchOffset;
        }

        @Override
        public final long batchLength() {
            return this.batchLength;
        }

        @Override
        public final void iterateEntities(Consumer<? super StorageChannelImportEntity> iterator) {
            StorageChannelImportEntity.Default e = this.first();
            while (e != null) {
                iterator.accept(e);
                e = e.next;
            }
        }

        @Override
        public final StorageChannelImportEntity.Default first() {
            return this.type != null ? this : this.batchNext;
        }

        public final String toString() {
            return "batch[" + this.length + "]" + (String)(this.batchNext == null ? "" : " " + this.batchNext.toString());
        }
    }
}

