/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.persistence.binary.types.BinaryChannelCountProvider;

@FunctionalInterface
public interface StorageChannelCountProvider
extends BinaryChannelCountProvider {
    public int getChannelCount();

    public static int validateChannelCount(int channelCount) throws IllegalArgumentException {
        Validation.validateParameters(channelCount);
        return channelCount;
    }

    public static StorageChannelCountProvider New() {
        return StorageChannelCountProvider.New(Defaults.defaultChannelCount());
    }

    public static StorageChannelCountProvider New(int channelCount) {
        Validation.validateParameters(channelCount);
        return new Default(channelCount);
    }

    public static final class Default
    implements StorageChannelCountProvider {
        private final int channelCount;

        Default(int channelCount) {
            this.channelCount = channelCount;
        }

        @Override
        public final int getChannelCount() {
            return this.channelCount;
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().blank().add("channel count").tab().add('=').blank().add(this.channelCount).toString();
        }
    }

    public static interface Validation {
        public static int maximumChannelCount() {
            return 1024;
        }

        public static int minimumChannelCount() {
            return 1;
        }

        public static boolean isValidChannelCountRange(int channelCount) {
            return channelCount >= Validation.minimumChannelCount() && channelCount <= Validation.maximumChannelCount();
        }

        public static boolean isValidChannelCountPow2Value(int channelCount) {
            return XMath.isPow2((int)channelCount);
        }

        public static void validateParameters(int channelCount) throws IllegalArgumentException {
            if (!Validation.isValidChannelCountRange(channelCount)) {
                throw new IllegalArgumentException("Specified channel count " + channelCount + " is not in the range of valid channel counts: " + XChars.mathRangeIncInc((long)Validation.minimumChannelCount(), (long)Validation.maximumChannelCount()) + ".");
            }
            if (!Validation.isValidChannelCountPow2Value(channelCount)) {
                throw new IllegalArgumentException("Specified channel count " + channelCount + " is not a power-of-2 int value (i.e. channelCount = 2^n for any n in [0;30], e.g. 1, 2, 4, 8, 16, ...).");
            }
        }
    }

    public static interface Defaults {
        public static int defaultChannelCount() {
            return 1;
        }
    }
}

