/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.afs.types.ADirectory;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageBackupFileProvider;
import org.eclipse.store.storage.types.StorageBackupHandler;
import org.eclipse.store.storage.types.StorageBackupItemQueue;
import org.eclipse.store.storage.types.StorageDataFileValidator;
import org.eclipse.store.storage.types.StorageFileWriter;
import org.eclipse.store.storage.types.StorageFileWriterBackupping;
import org.eclipse.store.storage.types.StorageOperationController;
import org.eclipse.store.storage.types.StorageTypeDictionary;
import org.eclipse.store.storage.types.StorageWriteController;

public interface StorageBackupSetup {
    public StorageBackupFileProvider backupFileProvider();

    public StorageFileWriter.Provider setupWriterProvider(StorageFileWriter.Provider var1);

    public StorageBackupHandler setupHandler(StorageOperationController var1, StorageWriteController var2, StorageDataFileValidator.Creator var3, StorageTypeDictionary var4);

    public static StorageBackupSetup New(ADirectory backupDirectory) {
        StorageBackupFileProvider backupFileProvider = ((StorageBackupFileProvider.Builder)StorageBackupFileProvider.Builder(backupDirectory.fileSystem()).setDirectory(backupDirectory)).createFileProvider();
        return StorageBackupSetup.New(backupFileProvider);
    }

    public static StorageBackupSetup New(StorageBackupFileProvider backupFileProvider) {
        return new Default((StorageBackupFileProvider)X.notNull((Object)backupFileProvider), StorageBackupItemQueue.New());
    }

    public static final class Default
    implements StorageBackupSetup {
        private final StorageBackupFileProvider backupFileProvider;
        private final StorageBackupItemQueue itemQueue;

        Default(StorageBackupFileProvider backupFileProvider, StorageBackupItemQueue itemQueue) {
            this.backupFileProvider = backupFileProvider;
            this.itemQueue = itemQueue;
        }

        @Override
        public final StorageBackupFileProvider backupFileProvider() {
            return this.backupFileProvider;
        }

        @Override
        public StorageFileWriter.Provider setupWriterProvider(StorageFileWriter.Provider writerProvider) {
            return StorageFileWriterBackupping.Provider(this.itemQueue, writerProvider);
        }

        @Override
        public StorageBackupHandler setupHandler(StorageOperationController operationController, StorageWriteController writeController, StorageDataFileValidator.Creator validatorCreator, StorageTypeDictionary typeDictionary) {
            int channelCount = operationController.channelCountProvider().getChannelCount();
            return StorageBackupHandler.New(this, channelCount, this.itemQueue, operationController, writeController, validatorCreator, typeDictionary);
        }
    }
}

