/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.store.storage.types.StorageBackupHandler;
import org.eclipse.store.storage.types.StorageBackupItemEnqueuer;
import org.eclipse.store.storage.types.StorageFileUser;
import org.eclipse.store.storage.types.StorageLiveChannelFile;

public interface StorageBackupItemQueue
extends StorageBackupItemEnqueuer,
StorageFileUser {
    public boolean processNextItem(StorageBackupHandler var1, long var2) throws InterruptedException;

    public boolean isEmpty();

    public static StorageBackupItemQueue New() {
        return new Default();
    }

    public static final class Default
    implements StorageBackupItemQueue {
        private final Item head;
        private Item tail;

        Default() {
            this.tail = this.head = new Item(null);
        }

        @Override
        public final boolean isEmpty() {
            return this.head.next == null;
        }

        @Override
        public final void enqueueCopyingItem(StorageLiveChannelFile<?> sourceFile, long sourcePosition, long length) {
            this.internalEnqueueItem(new CopyItem(sourceFile, sourcePosition, length));
        }

        @Override
        public final void enqueueTruncatingItem(StorageLiveChannelFile<?> file, long newLength) {
            this.internalEnqueueItem(new TruncationItem(file, newLength));
        }

        @Override
        public void enqueueDeletionItem(StorageLiveChannelFile<?> file) {
            this.internalEnqueueItem(new DeletionItem(file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEnqueueItem(Item item) {
            item.sourceFile.registerUsage(this);
            Item item2 = this.head;
            synchronized (item2) {
                this.tail = this.tail.next = item;
                this.head.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean processNextItem(StorageBackupHandler handler, long timeoutMs) throws InterruptedException {
            long timeBudgetBound = System.currentTimeMillis() + timeoutMs;
            long waitInterval = timeoutMs / 16L;
            Item item = this.head;
            synchronized (item) {
                while (this.head.next == null) {
                    if (!handler.isRunning()) {
                        return true;
                    }
                    if (System.currentTimeMillis() >= timeBudgetBound) {
                        return false;
                    }
                    this.head.wait(waitInterval);
                }
                Item itemToBeProcessed = this.head.next;
                itemToBeProcessed.processBy(handler);
                itemToBeProcessed.sourceFile.unregisterUsageClosing(this, null);
                this.head.next = itemToBeProcessed.next;
                if (this.head.next == null) {
                    this.tail = this.head;
                }
                return true;
            }
        }

        static final class DeletionItem
        extends Item {
            DeletionItem(StorageLiveChannelFile<?> sourceFile) {
                super(sourceFile);
            }

            @Override
            public void processBy(StorageBackupHandler handler) {
                handler.deleteFile(this.sourceFile);
            }
        }

        static final class TruncationItem
        extends Item {
            final long length;

            TruncationItem(StorageLiveChannelFile<?> sourceFile, long length) {
                super(sourceFile);
                this.length = length;
            }

            @Override
            public void processBy(StorageBackupHandler handler) {
                handler.truncateFile(this.sourceFile, this.length);
            }
        }

        static final class CopyItem
        extends Item {
            final long sourcePosition;
            final long length;

            CopyItem(StorageLiveChannelFile<?> sourceFile, long sourcePosition, long length) {
                super(sourceFile);
                this.sourcePosition = sourcePosition;
                this.length = length;
            }

            @Override
            public void processBy(StorageBackupHandler handler) {
                handler.copyFilePart(this.sourceFile, this.sourcePosition, this.length);
            }
        }

        static class Item {
            final StorageLiveChannelFile<?> sourceFile;
            Item next;

            public Item(StorageLiveChannelFile<?> sourceFile) {
                this.sourceFile = sourceFile;
            }

            public void processBy(StorageBackupHandler handler) {
            }
        }
    }
}

