/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.persistence.binary.types.Binary;

public final class EntityDataHeaderEvaluator {
    private final long lengthLowerValue;
    private final long lengthUpperBound;
    private final long typeIdLowerValue;
    private final long typeIdUpperBound;
    private final long objectIdLowerValue;
    private final long objectIdUpperBound;

    EntityDataHeaderEvaluator(long lengthLowerValue, long lengthUpperBound, long typeIdLowerValue, long typeIdUpperBound, long objectIdLowerValue, long objectIdUpperBound) {
        this.lengthLowerValue = lengthLowerValue;
        this.lengthUpperBound = lengthUpperBound;
        this.typeIdLowerValue = typeIdLowerValue;
        this.typeIdUpperBound = typeIdUpperBound;
        this.objectIdLowerValue = objectIdLowerValue;
        this.objectIdUpperBound = objectIdUpperBound;
    }

    private static boolean isValid(long lowerValue, long upperBound, long value) {
        if (value < lowerValue) {
            return false;
        }
        return value < upperBound;
    }

    public boolean isValidHeader(long entityStartAddress, long availableDataLength) {
        long objectId;
        long typeId;
        if ((long)Binary.entityHeaderLength() > availableDataLength) {
            return false;
        }
        long length = Binary.getEntityLengthRawValue((long)entityStartAddress);
        if (!this.isValidHeader(length, typeId = Binary.getEntityTypeIdRawValue((long)entityStartAddress), objectId = Binary.getEntityObjectIdRawValue((long)entityStartAddress))) {
            return false;
        }
        return length <= availableDataLength;
    }

    public boolean isValidHeader(long length, long typeId, long objectId) {
        if (!EntityDataHeaderEvaluator.isValid(this.lengthLowerValue, this.lengthUpperBound, length)) {
            return false;
        }
        if (!EntityDataHeaderEvaluator.isValid(this.typeIdLowerValue, this.typeIdUpperBound, typeId)) {
            return false;
        }
        return EntityDataHeaderEvaluator.isValid(this.objectIdLowerValue, this.objectIdUpperBound, objectId);
    }
}

