/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.monitoring;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.serializer.monitoring.MetricMonitor;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.store.storage.monitoring.StorageManagerMonitorMXBean;
import org.eclipse.store.storage.types.StorageManager;
import org.eclipse.store.storage.types.StorageRawFileStatistics;

public class StorageManagerMonitor
implements StorageManagerMonitorMXBean,
MetricMonitor {
    private final WeakReference<StorageManager> storageManager;

    public StorageManagerMonitor(StorageManager storageConnection) {
        this.storageManager = new WeakReference<StorageManager>(storageConnection);
    }

    @Override
    public void issueFullGarbageCollection() {
        ((StorageManager)this.storageManager.get()).issueFullGarbageCollection();
    }

    @Override
    public void issueFullCacheCheck() {
        ((StorageManager)this.storageManager.get()).issueFullCacheCheck();
    }

    @Override
    public void issueFullFileCheck() {
        ((StorageManager)this.storageManager.get()).issueFullFileCheck();
    }

    @Override
    public StorageStatistics getStorageStatistics() {
        return new StorageStatistics(((StorageManager)this.storageManager.get()).createStorageStatistics());
    }

    public String getName() {
        return "name=EmbeddedStorage";
    }

    public static class StorageStatistics {
        private final int channelCount;
        private final long fileCount;
        private final long totalDataLength;
        private final long liveDataLength;
        private final List<ChannelStatistics> channelStatistics = new ArrayList<ChannelStatistics>();

        public StorageStatistics(StorageRawFileStatistics statistics) {
            this.channelCount = statistics.channelCount();
            this.fileCount = statistics.fileCount();
            this.totalDataLength = statistics.totalDataLength();
            this.liveDataLength = statistics.liveDataLength();
            statistics.channelStatistics().forEach(c -> this.channelStatistics.add(new ChannelStatistics((KeyValue<Integer, ? extends StorageRawFileStatistics.ChannelStatistics>)c)));
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public long getFileCount() {
            return this.fileCount;
        }

        public long getTotalDataLength() {
            return this.totalDataLength;
        }

        public long getLiveDataLength() {
            return this.liveDataLength;
        }

        public double getUsageRatio() {
            return (double)this.liveDataLength / (double)this.totalDataLength;
        }

        public List<ChannelStatistics> getChannelStatistics() {
            return this.channelStatistics;
        }
    }

    public static class ChannelStatistics {
        private final long fileCount;
        private final long totalDataLength;
        private final long liveDataLength;
        private final List<FileStatistics> fileStatistics = new ArrayList<FileStatistics>();

        public ChannelStatistics(KeyValue<Integer, ? extends StorageRawFileStatistics.ChannelStatistics> channelStatistics) {
            this.fileCount = ((StorageRawFileStatistics.ChannelStatistics)channelStatistics.value()).fileCount();
            this.totalDataLength = ((StorageRawFileStatistics.ChannelStatistics)channelStatistics.value()).totalDataLength();
            this.liveDataLength = ((StorageRawFileStatistics.ChannelStatistics)channelStatistics.value()).liveDataLength();
            ((StorageRawFileStatistics.ChannelStatistics)channelStatistics.value()).files().forEach(f -> this.fileStatistics.add(new FileStatistics((StorageRawFileStatistics.FileStatistics)f)));
        }

        public long getFileCount() {
            return this.fileCount;
        }

        public long getTotalDataLength() {
            return this.totalDataLength;
        }

        public long getLiveDataLength() {
            return this.liveDataLength;
        }

        public List<FileStatistics> getFileStatistics() {
            return this.fileStatistics;
        }
    }

    public static class FileStatistics {
        private final String fileName;
        private final long totalDataLength;
        private final long liveDataLength;

        public FileStatistics(StorageRawFileStatistics.FileStatistics fileStatistics) {
            this.fileName = fileStatistics.file();
            this.totalDataLength = fileStatistics.totalDataLength();
            this.liveDataLength = fileStatistics.liveDataLength();
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getTotalDataLength() {
            return this.totalDataLength;
        }

        public long getLiveDataLength() {
            return this.liveDataLength;
        }
    }
}

