/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceException;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryEntityRawDataAcceptor;

public interface BinaryEntityRawDataIterator {
    public long iterateEntityRawData(long var1, long var3, BinaryEntityRawDataAcceptor var5);

    public static BinaryEntityRawDataIterator New() {
        return new Default();
    }

    public static Provider Provider() {
        return new Provider.Default();
    }

    public static interface Provider {
        public BinaryEntityRawDataIterator provideEntityDataIterator();

        public static final class Default
        implements Provider {
            @Override
            public BinaryEntityRawDataIterator provideEntityDataIterator() {
                return BinaryEntityRawDataIterator.New();
            }
        }
    }

    public static final class Default
    implements BinaryEntityRawDataIterator {
        Default() {
        }

        @Override
        public long iterateEntityRawData(long startAddress, long boundAddress, BinaryEntityRawDataAcceptor entityDataAcceptor) {
            long itemStartBoundAddress = boundAddress - (long)Binary.lengthLength() + 1L;
            long address = startAddress;
            try {
                while (address < itemStartBoundAddress) {
                    long itemLength = XMemory.get_long((long)address);
                    if (itemLength > 0L) {
                        if (!entityDataAcceptor.acceptEntityData(address, boundAddress)) break;
                        address += itemLength;
                        continue;
                    }
                    if (itemLength < 0L) {
                        address -= itemLength;
                        continue;
                    }
                    throw new BinaryPersistenceException("Zero length data item.");
                }
            }
            catch (Exception e) {
                throw new BinaryPersistenceException("Exception at address offset " + (address - startAddress) + " (bound offset = " + (boundAddress - startAddress) + ")", e);
            }
            return boundAddress - address;
        }
    }
}

