/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.collections.types.XMap;
import org.eclipse.serializer.collections.types.XTable;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustom;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceObjectRegistry;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceRootEntry;
import org.eclipse.serializer.persistence.types.PersistenceRootResolver;
import org.eclipse.serializer.persistence.types.PersistenceRootResolverProvider;
import org.eclipse.serializer.persistence.types.PersistenceRoots;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import org.eclipse.serializer.reference.Referencing;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public final class BinaryHandlerPersistenceRootsDefault
extends AbstractBinaryHandlerCustom<PersistenceRoots.Default> {
    private final PersistenceRootResolverProvider rootResolverProvider;
    final PersistenceObjectRegistry globalRegistry;

    public static BinaryHandlerPersistenceRootsDefault New(PersistenceRootResolverProvider rootResolverProvider, PersistenceObjectRegistry globalRegistry) {
        return new BinaryHandlerPersistenceRootsDefault((PersistenceRootResolverProvider)X.notNull((Object)rootResolverProvider), (PersistenceObjectRegistry)X.notNull((Object)globalRegistry));
    }

    BinaryHandlerPersistenceRootsDefault(PersistenceRootResolverProvider rootResolverProvider, PersistenceObjectRegistry globalRegistry) {
        super(PersistenceRoots.Default.class, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)BinaryHandlerPersistenceRootsDefault.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerPersistenceRootsDefault.Complex("instances", new PersistenceTypeDescriptionMemberFieldGeneric[]{BinaryHandlerPersistenceRootsDefault.CustomField(Object.class, "instance")}), BinaryHandlerPersistenceRootsDefault.Complex("identifiers", new PersistenceTypeDescriptionMemberFieldGeneric[]{BinaryHandlerPersistenceRootsDefault.chars("identifier")})}));
        this.rootResolverProvider = rootResolverProvider;
        this.globalRegistry = globalRegistry;
    }

    public final boolean hasVaryingPersistedLengthInstances() {
        return true;
    }

    public final boolean hasPersistedReferences() {
        return true;
    }

    public final boolean hasPersistedVariableLength() {
        return true;
    }

    @Override
    public final void store(Binary data, PersistenceRoots.Default instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeRoots(this.typeId(), objectId, (XGettingTable<String, Object>)instance.entries(), (PersistenceFunction)handler);
    }

    @Override
    public final PersistenceRoots.Default create(Binary data, PersistenceLoadHandler handler) {
        EqHashTable rootIdMapping = data.buildRootMapping(EqHashTable.New());
        return PersistenceRoots.Default.New((PersistenceRootResolver)this.rootResolverProvider.provideRootResolver(), (EqHashTable)rootIdMapping);
    }

    public final void updateState(Binary data, PersistenceRoots.Default instance, PersistenceLoadHandler handler) {
        PersistenceRootResolver rootResolver = instance.$rootResolver();
        EqHashTable rootIdMapping = instance.$rootIdMapping();
        EqHashTable resolvedRootEntries = EqHashTable.New();
        this.ensureRefactoredOldRoots((EqHashTable<String, Long>)rootIdMapping, (EqHashTable<String, PersistenceRootEntry>)resolvedRootEntries, handler);
        rootResolver.resolveRootEntries((XMap)resolvedRootEntries, (XGettingEnum)rootIdMapping.keys());
        XTable resolvedRoots = rootResolver.resolveRootInstances((XGettingTable)resolvedRootEntries);
        instance.loadingUpdateEntries((XGettingTable)resolvedRoots);
        this.registerInstancesPerObjectId((XGettingTable<String, PersistenceRootEntry>)resolvedRootEntries, (XGettingTable<String, Long>)rootIdMapping);
    }

    @Deprecated
    private boolean ensureRefactoredOldRoots(EqHashTable<String, Long> rootIdMapping, EqHashTable<String, PersistenceRootEntry> resolvedRoots, PersistenceLoadHandler handler) {
        Long customRootOid = (Long)rootIdMapping.get((Object)Persistence.customRootIdentifier());
        Long defaultRootOid = (Long)rootIdMapping.get((Object)Persistence.defaultRootIdentifier());
        if (customRootOid == null && defaultRootOid == null) {
            return false;
        }
        Object root = this.rootResolverProvider.rootReference().get();
        if (root == null) {
            if (customRootOid != null) {
                Object customRoot = handler.lookupObject(customRootOid.longValue());
                if (customRoot == null) {
                    throw new Error("Root instance missing for identifier \"" + Persistence.customRootIdentifier() + "\"");
                }
                this.rootResolverProvider.rootReference().set(customRoot);
                resolvedRoots.add((Object)Persistence.customRootIdentifier(), null);
                return true;
            }
            if (defaultRootOid != null) {
                Object defaultRoot = handler.lookupObject(defaultRootOid.longValue());
                if (defaultRoot == null) {
                    throw new Error("Root instance missing for identifier \"" + Persistence.defaultRootIdentifier() + "\"");
                }
                if (!(defaultRoot instanceof Referencing)) {
                    throw new Error("Inconsistently typed default root instance: " + XChars.systemString((Object)defaultRoot));
                }
                Referencing casted = (Referencing)defaultRoot;
                this.rootResolverProvider.rootReference().setRootSupplier(() -> casted.get());
                resolvedRoots.add((Object)Persistence.defaultRootIdentifier(), null);
                return true;
            }
        } else {
            if (customRootOid != null) {
                handler.registerCustomRootRefactoring(root, customRootOid.longValue());
                resolvedRoots.add((Object)Persistence.customRootIdentifier(), null);
                return true;
            }
            if (defaultRootOid != null) {
                handler.registerDefaultRootRefactoring(root, defaultRootOid.longValue());
                resolvedRoots.add((Object)Persistence.defaultRootIdentifier(), null);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstancesPerObjectId(XGettingTable<String, PersistenceRootEntry> resolvedRootEntries, XGettingTable<String, Long> rootIdMapping) {
        PersistenceObjectRegistry registry;
        PersistenceObjectRegistry persistenceObjectRegistry = registry = this.globalRegistry;
        synchronized (persistenceObjectRegistry) {
            for (KeyValue rootEntry : resolvedRootEntries) {
                Object rootInstance;
                if (rootEntry.value() == null || (rootInstance = ((PersistenceRootEntry)rootEntry.value()).instance()) == null) continue;
                Long rootObjectId = (Long)rootIdMapping.get((Object)((String)rootEntry.key()));
                registry.registerConstant(rootObjectId.longValue(), rootInstance);
            }
        }
    }

    @Override
    public final void complete(Binary data, PersistenceRoots.Default instance, PersistenceLoadHandler handler) {
        instance.$discardRootIdMapping();
    }

    @Override
    public final void iterateInstanceReferences(PersistenceRoots.Default instance, PersistenceFunction iterator) {
        for (Object object : instance.entries().values()) {
            iterator.apply(object);
        }
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        data.iterateListElementReferences(0L, (PersistenceObjectIdAcceptor)iterator);
    }
}

