/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.right;

import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.right.RightParser;
import com.schneide.base.loader.xml.AbstractXMLModelHandler;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import org.jdom2.Document;

public class RightParserHandler
extends AbstractXMLModelHandler {
    private final RightParser parser = new RightParser();

    public RightParserHandler(File specificationFile) {
        super(specificationFile, false);
        if (!specificationFile.exists()) {
            this.setRootRights(new Right[0]);
        }
    }

    protected Document marshalModel(Object model) {
        return this.parser.factorDocument((Right[])model);
    }

    public Right[] getRootRights() {
        return (Right[])this.getModel(false);
    }

    public void setRootRights(Right[] rights) {
        try {
            this.saveModel(rights);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Could not save access control data.", (Throwable)e);
        }
    }

    protected Object unmarshalModel(Document document) {
        this.getLogger().debug((Object)("Loading access control data from " + String.valueOf(document)));
        try {
            Right[] result = this.parser.parseDocument(document);
            return result;
        }
        catch (ParseException e) {
            this.getLogger().error((Object)"Could not read in access control data.", (Throwable)e);
            return null;
        }
    }

    public static Right[] loadRights(File specFile) {
        Right[] result = new RightParserHandler(specFile).getRootRights();
        if (null == result) {
            return new Right[0];
        }
        return result;
    }

    public static void saveRights(File specFile, Right ... rights) {
        new RightParserHandler(specFile).setRootRights(rights);
    }
}

