/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.right;

import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.right.GenericRight;
import com.schneide.base.datatypes.AbstractDataParser;
import com.schneide.base.util.Parameter;
import java.text.ParseException;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class RightParser
extends AbstractDataParser {
    private static final String ROOT_TAG = "rights";
    private static final String RIGHT_TAG = "right";
    private static final String RIGHT_IDENTIFIER_ATTRIBUTE = "identifier";
    private static final String RIGHT_DENOTATION_ATTRIBUTE = "denotation";

    public Right[] parseDocument(Document document) throws ParseException {
        Element rootElement = document.getRootElement();
        if (!ROOT_TAG.equals(rootElement.getName())) {
            throw new ParseException(rootElement.getName(), 0);
        }
        Element[] rootRightElements = AbstractDataParser.toElementArray((List)rootElement.getChildren(RIGHT_TAG));
        Right[] rights = new Right[rootRightElements.length];
        for (int i = 0; i < rootRightElements.length; ++i) {
            rights[i] = this.parseRight(rootRightElements[i], null);
        }
        return rights;
    }

    protected Right parseRight(Element rightElement, Right parent) {
        Element[] rightElements;
        String identifier = rightElement.getAttributeValue(RIGHT_IDENTIFIER_ATTRIBUTE);
        String denotation = rightElement.getAttributeValue(RIGHT_DENOTATION_ATTRIBUTE);
        Parameter.isPresent((String)identifier, (Object)denotation);
        GenericRight right = new GenericRight(identifier, denotation);
        right.setParentRight(parent);
        if (null != rightElement.getAttributeValue("parent")) {
            String desiredParent = rightElement.getAttributeValue("parent");
            right.setParentRightIdentifier(desiredParent);
        }
        for (Element element : rightElements = AbstractDataParser.toElementArray((List)rightElement.getChildren(RIGHT_TAG))) {
            this.parseRight(element, right);
        }
        return right;
    }

    public Document factorDocument(Right[] rights) {
        Element rootElement = new Element(ROOT_TAG);
        this.factorRights(rights, rootElement);
        Document rootDocument = new Document(rootElement);
        return rootDocument;
    }

    protected void factorRights(Right[] rights, Element parentElement) {
        for (Right currentRight : rights) {
            Element element = this.createXMLElementFor(currentRight);
            parentElement.addContent((Content)element);
        }
    }

    protected Element createXMLElementFor(Right right) {
        Element result = new Element(RIGHT_TAG);
        result.setAttribute(RIGHT_IDENTIFIER_ATTRIBUTE, right.getIdentifier());
        result.setAttribute(RIGHT_DENOTATION_ATTRIBUTE, right.getDenotation());
        this.factorRights(right.getChildren(), result);
        return result;
    }
}

