/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.right;

import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.dialog.message.RightNotGrantedDialog;
import com.schneide.base.application.usermanagement.model.CheckableCredential;
import com.schneide.base.system.Base;

public final class RightChecker {
    private static GUIMode currentMode = GUIMode.NO_GRAPHICS;

    private RightChecker() {
    }

    public static void setGUIMode(GUIMode newMode) {
        currentMode = newMode;
    }

    public static boolean cannotProceed(CheckableCredential credential, SchneideSession<?> session) {
        if (credential.isGrantedFor(session)) {
            return false;
        }
        if (GUIMode.USER_DIALOG == currentMode) {
            RightNotGrantedDialog dialog = new RightNotGrantedDialog(credential.getIdentifier());
            dialog.show();
        }
        Base.getLogger(RightChecker.class).warn((Object)("User " + String.valueOf(session.getUser()) + " failed to perform action " + String.valueOf(credential) + " due to security restrictions."));
        return true;
    }

    public static enum GUIMode {
        USER_DIALOG,
        NO_GRAPHICS;

    }
}

