/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.right;

import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.model.RightConfiguration;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.right.RightParserHandler;
import com.schneide.base.application.usermanagement.right.RootRight;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DefaultRightHandler
implements RightHandler {
    private final RootRight rootAccessControl;

    public DefaultRightHandler(RightConfiguration rightConfiguration) {
        RootRight rootControl = new RootRight();
        for (File configurationFile : rightConfiguration.getRightConfigurationFiles()) {
            this.loadRights(rootControl, configurationFile, RightCategory.PUBLIC);
        }
        for (File configurationFile : rightConfiguration.getInternalRightConfigurationFiles()) {
            this.loadRights(rootControl, configurationFile, RightCategory.INTERNAL);
        }
        this.rootAccessControl = rootControl;
    }

    private void loadRights(RootRight rootControl, File configurationFile, RightCategory category) {
        Right[] rights;
        for (Right right : rights = RightParserHandler.loadRights(configurationFile)) {
            right.setIsInternal(RightCategory.INTERNAL == category);
            rootControl.addChildRight(right);
        }
    }

    @Override
    public RootRight getRootRight() {
        return this.rootAccessControl;
    }

    public void addRight(Right newRight) {
        newRight.setParentRight(this.getRootRight());
    }

    public Iterable<Right> getDependentRightsFor(String rightIdentifier) {
        Right[] potentiallyMismounted;
        ArrayList<Right> result = new ArrayList<Right>();
        for (Right right : potentiallyMismounted = this.getRootRight().getChildren()) {
            if (!rightIdentifier.equals(right.getParentRightIdentifier())) continue;
            result.add(right);
        }
        return result;
    }

    @Override
    public Iterable<Right> getRights() {
        ArrayList<Right> rightList = new ArrayList<Right>();
        DefaultRightHandler.addRights(rightList, this.getRootRight());
        return rightList;
    }

    private static void addRights(List<Right> accessControlList, Right parentControl) {
        accessControlList.add(parentControl);
        for (Right control : parentControl.getChildren()) {
            DefaultRightHandler.addRights(accessControlList, control);
        }
    }

    public void removeRight(Right dependent) {
        for (Right current : this.getRootRight().getChildren()) {
            if (!dependent.getIdentifier().equals(current.getIdentifier())) continue;
            this.getRootRight().removeChildAccess(dependent);
        }
    }

    private static enum RightCategory {
        PUBLIC,
        INTERNAL;

    }
}

