/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.internal;

import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VolatileUserHandler<U extends SchneideUser>
extends LoggedObject
implements SchneideUserHandler<U> {
    private final UserGroupHandler groupHandler;
    private final List<U> userList;

    public VolatileUserHandler(UserGroupHandler groupHandler) {
        this.groupHandler = groupHandler;
        this.userList = new ArrayList<U>();
    }

    @Override
    public void load() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(U user) {
        List<U> list = this.userList;
        synchronized (list) {
            this.userList.add(user);
            for (SchneideUserGroup group : user.getUserGroups()) {
                group.addUserGroupValueChangeListener(this.getUserGroupHandler());
            }
            user.addUserValueChangeListener(this);
        }
    }

    protected UserGroupHandler getUserGroupHandler() {
        return this.groupHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(U user) {
        List<U> list = this.userList;
        synchronized (list) {
            this.userList.remove(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<U> getAll() {
        List<U> list = this.userList;
        synchronized (list) {
            ArrayList<U> result = new ArrayList<U>(this.userList);
            return result;
        }
    }

    @Override
    public void notifyUserValueChanged(SchneideUser newUser) {
    }
}

