/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.internal;

import com.schneide.base.application.usermanagement.model.CredentialInferenceHandler;
import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.util.EqualsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DenyInDoubtInferenceHandler
implements CredentialInferenceHandler {
    private static final Map<PermissionUpdateState, EPermissionState> PERMISSION_UPDATE_MAP = DenyInDoubtInferenceHandler.fillPermissionUpdateMap();
    private final RightHandler rightHandler;

    public DenyInDoubtInferenceHandler(RightHandler rightHandler) {
        this.rightHandler = rightHandler;
    }

    private static Map<PermissionUpdateState, EPermissionState> fillPermissionUpdateMap() {
        HashMap<PermissionUpdateState, EPermissionState> map = new HashMap<PermissionUpdateState, EPermissionState>();
        map.put(new PermissionUpdateState(EPermissionState.HAS_PERMISSION, EPermissionState.HAS_PERMISSION), EPermissionState.HAS_PERMISSION);
        map.put(new PermissionUpdateState(EPermissionState.HAS_PERMISSION, EPermissionState.PERMISSION_DENIED), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.HAS_PERMISSION, EPermissionState.UNDETERMINED_NO_INFORMATION), EPermissionState.HAS_PERMISSION);
        map.put(new PermissionUpdateState(EPermissionState.HAS_PERMISSION, EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.PERMISSION_DENIED, EPermissionState.HAS_PERMISSION), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.PERMISSION_DENIED, EPermissionState.PERMISSION_DENIED), EPermissionState.PERMISSION_DENIED);
        map.put(new PermissionUpdateState(EPermissionState.PERMISSION_DENIED, EPermissionState.UNDETERMINED_NO_INFORMATION), EPermissionState.PERMISSION_DENIED);
        map.put(new PermissionUpdateState(EPermissionState.PERMISSION_DENIED, EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_NO_INFORMATION, EPermissionState.HAS_PERMISSION), EPermissionState.HAS_PERMISSION);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_NO_INFORMATION, EPermissionState.PERMISSION_DENIED), EPermissionState.PERMISSION_DENIED);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_NO_INFORMATION, EPermissionState.UNDETERMINED_NO_INFORMATION), EPermissionState.UNDETERMINED_NO_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_NO_INFORMATION, EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION, EPermissionState.HAS_PERMISSION), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION, EPermissionState.PERMISSION_DENIED), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION, EPermissionState.UNDETERMINED_NO_INFORMATION), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        map.put(new PermissionUpdateState(EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION, EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION), EPermissionState.UNDETERMINED_DIFFERENT_INFORMATION);
        return map;
    }

    @Override
    public boolean hasPermission(SchneideUser user, String credentialIdentifier) {
        EPermissionState currentPermissionState = EPermissionState.UNDETERMINED_NO_INFORMATION;
        for (SchneideUserGroup group : user.getUserGroups()) {
            currentPermissionState = currentPermissionState.mergeWith(this.getPermission(group, credentialIdentifier));
        }
        currentPermissionState = this.considerAll(user.getCredentials(), credentialIdentifier, currentPermissionState);
        boolean result = currentPermissionState.hasPermission();
        return result;
    }

    protected EPermissionState considerAll(Iterable<SchneideCredential> credentials, String credentialIdentifier, EPermissionState initialState) {
        EPermissionState result = initialState;
        for (SchneideCredential credential : credentials) {
            if (credentialIdentifier.equals(credential.getKey())) {
                return this.retrievePermissionFrom(credential);
            }
            result = result.mergeWith(this.getPermission(credential, credentialIdentifier));
        }
        return result;
    }

    protected Right findRightFor(SchneideCredential credential) {
        return this.findRightFor(credential.getKey());
    }

    protected Right findRightFor(String credentialKey) {
        for (Right right : this.getRights()) {
            if (!right.getIdentifier().equals(credentialKey)) continue;
            return right;
        }
        return null;
    }

    protected EPermissionState getPermission(SchneideUserGroup group, String credentialIdentifier) {
        EPermissionState currentPermissionState = this.considerAll(group.getCredentials(), credentialIdentifier, EPermissionState.UNDETERMINED_NO_INFORMATION);
        if (group.hasParentGroup() && currentPermissionState.equals((Object)EPermissionState.UNDETERMINED_NO_INFORMATION)) {
            currentPermissionState = currentPermissionState.mergeWith(this.getPermission(group.getParentGroup(), credentialIdentifier));
        }
        return currentPermissionState;
    }

    protected EPermissionState getPermission(SchneideCredential credential, String credentialIdentifier) {
        Right right = this.findRightFor(credential);
        return this.getPermission(credential, right, credentialIdentifier);
    }

    protected EPermissionState getPermission(SchneideCredential credential, Right foundRight, String expectedIdentifier) {
        String foundIdentifier = this.determineIdentifier(credential, foundRight);
        if (foundIdentifier.equals(expectedIdentifier)) {
            return this.retrievePermissionFrom(credential);
        }
        EPermissionState currentPermissionState = EPermissionState.UNDETERMINED_NO_INFORMATION;
        for (Right childRight : credential.getType().getVisibleChildren(foundRight)) {
            currentPermissionState = currentPermissionState.mergeWith(this.getPermission(credential, childRight, expectedIdentifier));
        }
        return currentPermissionState;
    }

    protected EPermissionState retrievePermissionFrom(SchneideCredential credential) {
        if (credential.getIsPermission()) {
            return EPermissionState.HAS_PERMISSION;
        }
        return EPermissionState.PERMISSION_DENIED;
    }

    protected String determineIdentifier(SchneideCredential credential, Right foundRight) {
        if (null == foundRight) {
            return credential.getKey();
        }
        return foundRight.getIdentifier();
    }

    protected Iterable<Right> getRights() {
        return this.rightHandler.getRights();
    }

    private static class PermissionUpdateState
    implements EqualsBuilder.EqualComparable {
        private final EPermissionState currentState;
        private final EPermissionState newState;

        public PermissionUpdateState(EPermissionState currentState, EPermissionState newState) {
            this.currentState = currentState;
            this.newState = newState;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.isEqual((EqualsBuilder.EqualComparable)this, (Object)obj);
        }

        public Iterable<Object> getValuesToCompare() {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add((Object)this.currentState);
            result.add((Object)this.newState);
            return result;
        }

        public int hashCode() {
            return EqualsBuilder.hashCodeFor((EqualsBuilder.EqualComparable)this);
        }
    }

    protected static enum EPermissionState {
        UNDETERMINED_NO_INFORMATION(false),
        UNDETERMINED_DIFFERENT_INFORMATION(false),
        HAS_PERMISSION(true),
        PERMISSION_DENIED(false);

        private boolean hasPermission;

        private EPermissionState(boolean hasPermission) {
            this.hasPermission = hasPermission;
        }

        public boolean hasPermission() {
            return this.hasPermission;
        }

        public EPermissionState mergeWith(EPermissionState newState) {
            return PERMISSION_UPDATE_MAP.get(new PermissionUpdateState(this, newState));
        }
    }
}

