/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.table;

import com.schneide.base.application.usermanagement.dialog.table.TableSelectionColorProvider;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class TextAreaCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = 5977170134190419870L;
    private final TableSelectionColorProvider colorProvider = new TableSelectionColorProvider();

    public TextAreaCellRenderer() {
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            this.setText(String.valueOf(value));
        }
        this.setBackground(this.colorProvider.getBackgroundColor(table, isSelected, hasFocus));
        this.setForeground(this.colorProvider.getForegroundColor(table, isSelected, hasFocus));
        this.setFont(table.getFont());
        int width = table.getColumnModel().getColumn(column).getWidth();
        this.setSize(width, 1000);
        int rowHeigth = this.getPreferredSize().height;
        if (table.getRowHeight(row) != rowHeigth) {
            table.setRowHeight(row, rowHeigth);
        }
        return this;
    }
}

