/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.table;

import com.schneide.base.application.usermanagement.dialog.table.ColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.EditableColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.EntryHolder;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.component.SortableTableModel;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractHandlerTableModel<T>
extends AbstractTableModel
implements SortableTableModel {
    private static final long serialVersionUID = -6474112226388728392L;
    private final Logger logger;
    private final Iterable<ColumnValueHandler<T, ?>> columValueHandler = this.columValueHandlers();

    public AbstractHandlerTableModel() {
        this.logger = Base.getLogger((Object)this);
    }

    protected abstract Iterable<ColumnValueHandler<T, ?>> columValueHandlers();

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public int getColumnCount() {
        return IterableUtil.getSizeFor(this.columValueHandler);
    }

    protected abstract EntryHolder<T> getEntryHolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        EntryHolder<T> entryHolder = this.getEntryHolder();
        synchronized (entryHolder) {
            T object = this.getEntryHolder().getEntryAt(rowIndex);
            return this.handlerAt(columnIndex).getValue(object);
        }
    }

    protected ColumnValueHandler<T, ?> handlerAt(int columnIndex) {
        return (ColumnValueHandler)IterableUtil.getElementAt((int)columnIndex, this.columValueHandler);
    }

    @Override
    public int getRowCount() {
        return this.getEntryHolder().getRowCount();
    }

    public void sortColumn(int columnIndex, boolean ascending) {
        this.getEntryHolder().setSortInformation(this.handlerAt(columnIndex), ascending);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.handlerAt(columnIndex).isEditable();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        ((EditableColumnValueHandler)this.handlerAt(columnIndex)).setValue(this.getEntryHolder().getEntryAt(rowIndex), value);
    }

    @Override
    public String getColumnName(int column) {
        return this.handlerAt(column).getColumnName();
    }

    public void addEntry(T entry) {
        SwingUtilities.invokeLater(() -> {
            this.getEntryHolder().addEntry(entry);
            this.fireTableRowsInserted(0, 1);
        });
    }

    public T getEntryAt(int index) {
        return this.getEntryHolder().getEntryAt(index);
    }

    public void removeEntriesAt(int ... indicesToRemove) {
        Arrays.sort(indicesToRemove);
        this.getEntryHolder().removeEntriesAt(indicesToRemove);
        for (int i = indicesToRemove.length - 1; i >= 0; --i) {
            this.fireTableRowsDeleted(indicesToRemove[i], indicesToRemove[i]);
        }
    }
}

