/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.table.AbstractColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.AbstractHandlerTableModel;
import com.schneide.base.application.usermanagement.dialog.table.ColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.EntryHolder;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.system.Base;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import java.util.ArrayList;
import java.util.List;

public class UserTableModel<U extends SchneideUser>
extends AbstractHandlerTableModel<U> {
    private static final long serialVersionUID = -2895483619964492044L;
    private final SchneideUserHolder userHolder;

    public UserTableModel(SchneideUserHandler<U> userHandler, boolean showInternalUser) {
        this.userHolder = new SchneideUserHolder(this, userHandler, showInternalUser);
    }

    @Override
    protected Iterable<ColumnValueHandler<U, ?>> columValueHandlers() {
        ArrayList handlerList = new ArrayList();
        handlerList.add(new LoginValueHandler(this));
        handlerList.add(new NameValueHandler(this));
        handlerList.add(new GroupsValueHandler(this));
        return handlerList;
    }

    @Override
    protected EntryHolder<U> getEntryHolder() {
        return this.userHolder;
    }

    public U getUserAt(int index) {
        return this.userHolder.getUserAt(index);
    }

    public String getGroupColumnIdentifier() {
        return new GroupsValueHandler(this).getColumnName();
    }

    private class SchneideUserHolder
    extends EntryHolder<U> {
        private final SchneideUserHandler<U> userHandler;
        private final boolean showInternalUser;

        public SchneideUserHolder(UserTableModel userTableModel, SchneideUserHandler<U> userHandler, boolean showInternalUser) {
            this.userHandler = userHandler;
            this.showInternalUser = showInternalUser;
        }

        public U getUserAt(int index) {
            return (SchneideUser)this.getEntryAt(index);
        }

        private SchneideUserHandler<U> getUserHandler() {
            return this.userHandler;
        }

        private boolean isShowInternalUsers() {
            return this.showInternalUser;
        }

        @Override
        protected List<U> getAllEntries() {
            Iterable schneideUsers = this.getUserHandler().getAll();
            ArrayList<SchneideUser> userList = new ArrayList<SchneideUser>();
            for (SchneideUser schneideUser : schneideUsers) {
                if (!this.isShowInternalUsers() && schneideUser.getIsInternal()) continue;
                userList.add(schneideUser);
            }
            return userList;
        }

        @Override
        protected void insertEntry(U user) {
            this.getUserHandler().add(user);
        }

        @Override
        protected void deleteEntries(List<U> entriesToDelete) {
            for (SchneideUser user : entriesToDelete) {
                this.getUserHandler().delete(user);
            }
        }
    }

    private class LoginValueHandler
    extends AbstractColumnValueHandler<U, String> {
        public LoginValueHandler(UserTableModel userTableModel) {
        }

        @Override
        public String getColumnName() {
            return Base.getTextContent().getText("UserTableModel.colum.user.login.title");
        }

        @Override
        public String getValue(SchneideUser user) {
            return user.getLogIn();
        }
    }

    private class NameValueHandler
    extends AbstractColumnValueHandler<U, String> {
        public NameValueHandler(UserTableModel userTableModel) {
        }

        @Override
        public String getColumnName() {
            return Base.getTextContent().getText("UserTableModel.colum.user.name.title");
        }

        @Override
        public String getValue(SchneideUser user) {
            return user.getFullName();
        }
    }

    private class GroupsValueHandler
    extends AbstractColumnValueHandler<U, String> {
        public GroupsValueHandler(UserTableModel userTableModel) {
        }

        @Override
        public String getColumnName() {
            return Base.getTextContent().getText("UserTableModel.colum.user.groups.title");
        }

        @Override
        public String getValue(U user) {
            DirectChunkBuffer content = new DirectChunkBuffer((CharSequence)"\n");
            for (SchneideUserGroup userGroup : user.getUserGroups()) {
                content.add((CharSequence)userGroup.getName());
            }
            return content.toString();
        }
    }
}

