/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.table.AbstractColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.AbstractHandlerTableModel;
import com.schneide.base.application.usermanagement.dialog.table.ColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.EntryHolder;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.system.Base;
import java.util.ArrayList;
import java.util.List;

public class GroupTableModel
extends AbstractHandlerTableModel<SchneideUserGroup> {
    private static final long serialVersionUID = 7135202223784870040L;
    private final transient SchneideUserGroupHolder groupHolder;

    public GroupTableModel(UserGroupHandler groupHandler, boolean showInternalGroups) {
        this.groupHolder = new SchneideUserGroupHolder(groupHandler, showInternalGroups);
    }

    @Override
    protected Iterable<ColumnValueHandler<SchneideUserGroup, ?>> columValueHandlers() {
        return GroupTableModel.createColumnValueHandlers();
    }

    @Override
    protected EntryHolder<SchneideUserGroup> getEntryHolder() {
        return this.groupHolder;
    }

    private static Iterable<ColumnValueHandler<SchneideUserGroup, ?>> createColumnValueHandlers() {
        ArrayList handlerList = new ArrayList();
        handlerList.add(new NameValueHandler());
        handlerList.add(new ParentValueHandler());
        return handlerList;
    }

    public SchneideUserGroup getUserGroupAt(int index) {
        return this.groupHolder.getUserGroupAt(index);
    }

    private class SchneideUserGroupHolder
    extends EntryHolder<SchneideUserGroup> {
        private final UserGroupHandler groupHandler;
        private final boolean showInternalGroups;

        public SchneideUserGroupHolder(UserGroupHandler groupHandler, boolean showInternalGroups) {
            this.groupHandler = groupHandler;
            this.showInternalGroups = showInternalGroups;
        }

        public SchneideUserGroup getUserGroupAt(int index) {
            return (SchneideUserGroup)this.getEntryAt(index);
        }

        private boolean showInternalGroups() {
            return this.showInternalGroups;
        }

        @Override
        protected List<SchneideUserGroup> getAllEntries() {
            ArrayList<SchneideUserGroup> groupList = new ArrayList<SchneideUserGroup>();
            for (SchneideUserGroup group : this.getGroupHandler().getUserGroups()) {
                if (!this.showInternalGroups() && group.getIsInternal()) continue;
                groupList.add(group);
            }
            return groupList;
        }

        private UserGroupHandler getGroupHandler() {
            return this.groupHandler;
        }

        @Override
        protected void insertEntry(SchneideUserGroup userGroup) {
            this.getGroupHandler().addUserGroup(userGroup);
            GroupTableModel.this.fireTableRowsInserted(0, this.getRowCount());
        }

        @Override
        protected void deleteEntries(List<SchneideUserGroup> entriesToDelete) {
            for (SchneideUserGroup groupToDelete : entriesToDelete) {
                this.getGroupHandler().deleteUserGroup(groupToDelete);
            }
        }
    }

    private static class NameValueHandler
    extends AbstractColumnValueHandler<SchneideUserGroup, String> {
        @Override
        public String getColumnName() {
            return Base.getTextContent().getText("GroupTableModel.colum.group.name.title");
        }

        @Override
        public String getValue(SchneideUserGroup userGroup) {
            return userGroup.getName();
        }
    }

    private static class ParentValueHandler
    extends AbstractColumnValueHandler<SchneideUserGroup, String> {
        @Override
        public String getColumnName() {
            return Base.getTextContent().getText("GroupTableModel.colum.group.parent.title");
        }

        @Override
        public String getValue(SchneideUserGroup userGroup) {
            if (userGroup.hasParentGroup()) {
                return userGroup.getParentGroup().getName();
            }
            return "";
        }
    }
}

