/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.internal.GroupComparator;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.gui.swing.EDT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class GroupListModel
extends AbstractListModel<String> {
    private static final long serialVersionUID = -1719564413599932993L;
    private final List<SchneideUserGroup> groupList = new ArrayList<SchneideUserGroup>();
    private final List<SchneideUserGroup> additionalGroupList = new ArrayList<SchneideUserGroup>();

    public GroupListModel(Iterable<SchneideUserGroup> groups, boolean showInternalGroups) {
        for (SchneideUserGroup group : groups) {
            if (showInternalGroups || !group.getIsInternal()) {
                this.groupList.add(group);
                continue;
            }
            this.additionalGroupList.add(group);
        }
        this.sortGroups();
    }

    private void sortGroups() {
        Collections.sort(this.groupList, new GroupComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        List<SchneideUserGroup> list = this.groupList;
        synchronized (list) {
            return this.groupList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getElementAt(int index) {
        List<SchneideUserGroup> list = this.groupList;
        synchronized (list) {
            return this.groupList.get(index).getName();
        }
    }

    private List<SchneideUserGroup> getGroupList() {
        return this.groupList;
    }

    public void addGroup(SchneideUserGroup userGroup) {
        if (null == userGroup) {
            return;
        }
        EDT.later(() -> this.addGroupInternal(userGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addGroupInternal(SchneideUserGroup userGroup) {
        List<SchneideUserGroup> list = this.getGroupList();
        synchronized (list) {
            this.getGroupList().add(userGroup);
            this.sortGroups();
            this.fireIntervalAdded(this, 0, this.getSize());
        }
    }

    public void removeGroupsAt(int[] selectedIndices) {
        EDT.later(() -> {
            List<SchneideUserGroup> list = this.getGroupList();
            synchronized (list) {
                int oldSize = this.getSize();
                ArrayList<SchneideUserGroup> entriesToRemove = new ArrayList<SchneideUserGroup>();
                for (int selectedIndex : selectedIndices) {
                    entriesToRemove.add(this.getGroupList().get(selectedIndex));
                }
                this.getGroupList().removeAll(entriesToRemove);
                this.sortGroups();
                this.fireIntervalRemoved(this, 0, oldSize);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<SchneideUserGroup> getGroups() {
        List<SchneideUserGroup> list = this.groupList;
        synchronized (list) {
            ArrayList<SchneideUserGroup> totalGroupList = new ArrayList<SchneideUserGroup>();
            totalGroupList.addAll(this.getGroupList());
            totalGroupList.addAll(this.additionalGroupList);
            return totalGroupList;
        }
    }
}

