/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.table.AbstractColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.AbstractEditableColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.AbstractHandlerTableModel;
import com.schneide.base.application.usermanagement.dialog.table.ColumnValueHandler;
import com.schneide.base.application.usermanagement.dialog.table.EntryHolder;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.system.Base;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CredentialTableModel
extends AbstractHandlerTableModel<SchneideCredential> {
    private static final long serialVersionUID = -7024085208201779053L;
    private final SchneideCredentialHolder credentialHolder;

    public CredentialTableModel(Iterable<SchneideCredential> additionalCredentials, boolean showInternalCredentials) {
        this.credentialHolder = new SchneideCredentialHolder(additionalCredentials, showInternalCredentials);
    }

    @Override
    protected Iterable<ColumnValueHandler<SchneideCredential, ?>> columValueHandlers() {
        return CredentialTableModel.createColumnValueHandlers();
    }

    @Override
    protected EntryHolder<SchneideCredential> getEntryHolder() {
        return this.credentialHolder;
    }

    private static Iterable<ColumnValueHandler<SchneideCredential, ?>> createColumnValueHandlers() {
        ArrayList handlerList = new ArrayList();
        handlerList.add(new KeyValueHandler());
        handlerList.add(new RestrictionValueHandler());
        return handlerList;
    }

    public Iterable<SchneideCredential> getCredentials() {
        return this.getCredentialEntryHolder().getCredentials();
    }

    private SchneideCredentialHolder getCredentialEntryHolder() {
        return (SchneideCredentialHolder)this.getEntryHolder();
    }

    public String getPermissionColumnIdentifier() {
        return new RestrictionValueHandler().getColumnName();
    }

    private class SchneideCredentialHolder
    extends EntryHolder<SchneideCredential> {
        private final List<SchneideCredential> credentialList = new ArrayList<SchneideCredential>();
        private final List<SchneideCredential> additionalCredentialList = new ArrayList<SchneideCredential>();

        public SchneideCredentialHolder(Iterable<SchneideCredential> credentials, boolean showInternalCredentials) {
            for (SchneideCredential credential : credentials) {
                if (showInternalCredentials || !credential.getIsInternal()) {
                    this.credentialList.add(credential);
                    continue;
                }
                this.additionalCredentialList.add(credential);
            }
        }

        @Override
        public List<SchneideCredential> getAllEntries() {
            Collections.sort(this.credentialList, (o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
            return this.credentialList;
        }

        @Override
        protected void insertEntry(SchneideCredential entry) {
            this.credentialList.add(entry);
            CredentialTableModel.this.fireTableRowsInserted(0, this.getRowCount());
        }

        @Override
        protected void deleteEntries(List<SchneideCredential> entriesToDelete) {
            this.credentialList.removeAll(entriesToDelete);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<SchneideCredential> getCredentials() {
            EntryHolder<SchneideCredential> entryHolder = CredentialTableModel.this.getEntryHolder();
            synchronized (entryHolder) {
                ArrayList<SchneideCredential> totalCredentialList = new ArrayList<SchneideCredential>();
                totalCredentialList.addAll(this.getAllEntries());
                totalCredentialList.addAll(this.additionalCredentialList);
                return totalCredentialList;
            }
        }

        @Override
        public void addEntry(SchneideCredential entry) {
            if (this.credentialList.contains(entry)) {
                this.credentialList.remove(entry);
            }
            super.addEntry(entry);
        }
    }

    private static class KeyValueHandler
    extends AbstractColumnValueHandler<SchneideCredential, String> {
        @Override
        public String getColumnName() {
            return Base.getTextContent().getText("CredentialTableModel.colum.credential.key.name");
        }

        @Override
        public String getValue(SchneideCredential credential) {
            return credential.getDescription();
        }
    }

    private static class RestrictionValueHandler
    extends AbstractEditableColumnValueHandler<SchneideCredential, Boolean> {
        @Override
        public String getColumnName() {
            return Base.getTextContent().getText("CredentialTableModel.colum.restriction.name");
        }

        @Override
        public Boolean getValue(SchneideCredential credential) {
            return credential.getIsPermission();
        }

        @Override
        public void setValue(SchneideCredential credential, Object value) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("Wert konnte nicht gesetzt werden " + String.valueOf(value));
            }
            credential.setIsPermission((Boolean)value);
        }
    }
}

