/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.CreateSchneideUserDialog;
import com.schneide.base.application.usermanagement.dialog.EditSchneideUserDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AbstractSchneideSelectionDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.dialog.helper.UserTableModel;
import com.schneide.base.application.usermanagement.dialog.table.TextAreaCellEditor;
import com.schneide.base.application.usermanagement.dialog.table.TextAreaCellRenderer;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.system.Base;
import java.util.Optional;
import javax.swing.table.TableColumn;

public abstract class AbstractSchneideUserSelectionDialog<U extends SchneideUser>
extends AbstractSchneideSelectionDialog<U> {
    private final SchneideUserHandler<U> userHandler;
    private final UserGroupHandler groupHandler;
    private final RightHandler rightHandler;
    private final AdditionalInputHandler<U> additionalInputHandler;
    private final boolean showInternalInformation;

    public AbstractSchneideUserSelectionDialog(WindowStack session, I18NKey baseKey, SchneideUserHandler<U> userHandler, boolean showInternal, UserGroupHandler groupHandler, RightHandler rightHandler, AdditionalInputHandler<U> additionaInputCreator) {
        super(session, baseKey, Base.getTextContent().getText("AbstractSchneideUserSelectionDialog.type"), new UserTableModel<U>(userHandler, showInternal));
        this.userHandler = userHandler;
        this.showInternalInformation = showInternal;
        this.groupHandler = groupHandler;
        this.rightHandler = rightHandler;
        this.additionalInputHandler = additionaInputCreator;
    }

    @Override
    protected void buildUI() {
        super.buildUI();
        TableColumn groupsColumn = this.getTable().getColumn((Object)this.getUserTableModel().getGroupColumnIdentifier());
        groupsColumn.setCellRenderer(new TextAreaCellRenderer());
        groupsColumn.setCellEditor(new TextAreaCellEditor());
    }

    protected UserTableModel<U> getUserTableModel() {
        return (UserTableModel)this.getTableModel();
    }

    @Override
    protected void createNewContentObject() {
        CreateSchneideUserDialog<U> createDialog = new CreateSchneideUserDialog<U>(this.getWindowStack(), this.isShowInternalInformation(), this.userHandler, this.getGroupHandler(), this.getRightHandler(), this.getAdditionalInputHandler());
        Optional newUser = createDialog.showDialog();
        newUser.ifPresent(user -> this.getUserTableModel().addEntry(user));
    }

    public boolean isShowInternalInformation() {
        return this.showInternalInformation;
    }

    private UserGroupHandler getGroupHandler() {
        return this.groupHandler;
    }

    private RightHandler getRightHandler() {
        return this.rightHandler;
    }

    private AdditionalInputHandler<U> getAdditionalInputHandler() {
        return this.additionalInputHandler;
    }

    @Override
    protected void updateContentObjectAt(int index) {
        EditSchneideUserDialog<U> editDialog = new EditSchneideUserDialog<U>(this.getWindowStack(), this.getUserTableModel().getUserAt(index), this.isShowInternalInformation(), this.getGroupHandler(), this.getRightHandler(), this.getAdditionalInputHandler());
        editDialog.showDialog();
        if (editDialog.wasClosedByCommit()) {
            editDialog.updateSchneideUser();
            this.getUserTableModel().fireTableDataChanged();
        }
    }

    @Override
    protected void deleteContentObjectAt(int index) {
        this.getUserTableModel().removeEntriesAt(index);
    }

    @Override
    protected String getEntryIdentifier(int index) {
        return this.getUserTableModel().getUserAt(index).getLogIn();
    }
}

