/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.SchneideUserGroupSelectionDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.dialog.helper.CredentialGUIBuilder;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.NonvalidatingDialogButton;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.i18n.I18NDisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.input.helper.LayoutHelper;
import com.schneide.base.input.inputs.CheckboxInput;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.layout.StringGridBagLayoutStrategy;
import com.schneide.base.input.types.BooleanValue;
import com.schneide.base.input.types.StringValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.i18n.DefaultI18NValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.layout.GridBagLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractSchneideUserGroupDialog<U extends SchneideUser>
extends AbstractSchneideDialog<SchneideUserGroup> {
    private final UserGroupHandler groupHandler;
    private final RightHandler rightHandler;
    private final SchneideUserGroup userGroup;
    private final AdditionalInputHandler<U> additionalInputHandler;
    private final boolean showInternalInformation;
    private final StringValue nameValue;
    private final StringValue parentGroupValue;
    private final BooleanValue internalValue;
    private final CredentialGUIBuilder credentialPanel;
    private SchneideUserGroup parentGroup;

    public AbstractSchneideUserGroupDialog(WindowStack session, I18NKey baseKey, SchneideUserGroup schneideUserGroup, boolean showInternalInformation, UserGroupHandler groupHandler, RightHandler rightHandler, AdditionalInputHandler<U> additionalInputHandler) {
        super(session, (I18NKeyed)baseKey);
        this.showInternalInformation = showInternalInformation;
        this.groupHandler = groupHandler;
        this.rightHandler = rightHandler;
        this.userGroup = schneideUserGroup;
        this.additionalInputHandler = additionalInputHandler;
        this.nameValue = new StringValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.name"), new Object[0]), this.userGroup.getName());
        this.internalValue = new BooleanValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.internal"), new Object[0]), Boolean.valueOf(this.userGroup.getIsInternal()));
        this.parentGroupValue = new StringValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.parent.group"), new Object[0]));
        this.credentialPanel = new CredentialGUIBuilder(this.getWindowStack(), this.userGroup.getCredentials(), this.showInternalInformation, this.getRightHandler());
        this.credentialPanel.buildUI();
    }

    protected StringValue getNameValue() {
        return this.nameValue;
    }

    protected void buildUI() {
        this.setParentGroup(this.userGroup.getParentGroup());
        ArrayList<TextfieldInput> inputList = new ArrayList<TextfieldInput>();
        inputList.add(new TextfieldInput((Value)this.nameValue));
        CollectionUtil.addAll(inputList, this.additionalInputHandler.getAdditionalSchneideUserGroupInputs());
        TextfieldInput parentGroupInput = new TextfieldInput((Value)this.parentGroupValue);
        NonvalidatingDialogButton selectParentGroupButton = new NonvalidatingDialogButton((DisplayInformation)new I18NDisplayInformation(this.getLevelFullKey("button.select.parent.group")));
        selectParentGroupButton.addActionListener(e -> new Thread(() -> {
            SchneideUserGroupSelectionDialog<U> schneideUserGroupSelectionDialog = new SchneideUserGroupSelectionDialog<U>(this.getWindowStack(), this.getGroupHandler(), this.showInternalInformation, this.getRightHandler(), this.additionalInputHandler);
            schneideUserGroupSelectionDialog.showDialog();
            if (schneideUserGroupSelectionDialog.wasClosedByCommit()) {
                this.setParentGroup(schneideUserGroupSelectionDialog.getSelectedUserGroup());
            }
        }).start());
        parentGroupInput.setEditable(false);
        GridBagLayoutPanel gridPanel = new GridBagLayoutPanel();
        SchneideUserGroupDialogLayoutStrategy layoutStrategy = new SchneideUserGroupDialogLayoutStrategy();
        LayoutHelper.addToPanel((JPanel)gridPanel, (LayoutStrategy)layoutStrategy, inputList);
        layoutStrategy.addButtonInsteadOfUnitLabel((JPanel)gridPanel, (Input)parentGroupInput, (JButton)selectParentGroupButton);
        if (this.showInternalInformation) {
            new CheckboxInput((Value)this.internalValue).addToPanel((JPanel)gridPanel, (LayoutStrategy)layoutStrategy);
        }
        layoutStrategy.addScrollPane((JPanel)gridPanel, this.credentialPanel.getDisplayInformation(), new JScrollPane((Component)this.credentialPanel.getCredentialTable()), this.credentialPanel.getChangeCredentialPanel());
        gridPanel.setOpaque(true);
        this.setContent((JPanel)gridPanel);
        this.addButton().cancelButton();
        this.addButton().commitButton(this.createCommitButton());
    }

    protected final String getLevelFullKey(String keyPart) {
        return I18NKey.appendKeyParts((String[])new String[]{"AbstractSchneideUserGroupDialog", keyPart});
    }

    private Iterable<SchneideCredential> getCredentials() {
        return this.credentialPanel.getCredentials();
    }

    protected SchneideUserGroup getUserGroup() {
        return this.userGroup;
    }

    private UserGroupHandler getGroupHandler() {
        return this.groupHandler;
    }

    private RightHandler getRightHandler() {
        return this.rightHandler;
    }

    private void setParentGroup(SchneideUserGroup parentGroup) {
        this.parentGroup = parentGroup;
        String value = "";
        if (parentGroup != null) {
            value = parentGroup.getName();
        }
        this.parentGroupValue.setValue(value);
    }

    protected void updateUserGroup() {
        this.getUserGroup().update(this.nameValue.getValue(), this.parentGroup, this.internalValue.getValue(), this.getCredentials());
        this.additionalInputHandler.updateAdditionalSchneideUserGroupInputs();
    }

    protected abstract DialogButton createCommitButton();

    protected Optional<SchneideUserGroup> giveAnswer() {
        this.updateUserGroup();
        SchneideUserGroup result = this.getUserGroup();
        return Optional.ofNullable(result);
    }

    private static class SchneideUserGroupDialogLayoutStrategy
    extends StringGridBagLayoutStrategy {
        public void addButtonInsteadOfUnitLabel(JPanel panel, Input input, JButton button) {
            this.internalDefaultAddition(panel, input.getTitleLabel(), input.getInputComponent(), button);
        }

        public void addScrollPane(JPanel panel, ValueInformation valueInformation, JScrollPane scrollPane, JPanel buttonPanel) {
            this.internalAddTo(panel, new JComponent[]{new JLabel(valueInformation.getTitle()), scrollPane, buttonPanel}, new String[]{this.buildTitleLabelConstraints(), this.buildInputComponentConstraints() + "weighty=1, weightx=1, fill=BOTH", this.buildUnitLabelConstraints()});
        }
    }
}

