/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.gui.component.SchneideTable;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.NonvalidatingDialogButton;
import com.schneide.base.gui.dialog.defaults.QuestionDialog;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.layout.StringGridBagLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public abstract class AbstractSchneideSelectionDialog<TYPE>
extends AbstractSchneideDialog<TYPE> {
    private final SchneideTable selectionTable;
    private final String itemTypeDenotation;
    private final JButton editButton;
    private final JButton deleteButton;

    public AbstractSchneideSelectionDialog(WindowStack session, I18NKey baseKey, String itemTypeDenotation, TableModel tableModel) {
        super(session, (I18NKeyed)baseKey);
        this.itemTypeDenotation = itemTypeDenotation;
        this.selectionTable = new SchneideTable(tableModel);
        this.editButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)new I18NText(this.getLevelFullKey("button.edit"), new Object[]{this.getItemTypeDenotation()})));
        this.deleteButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)new I18NText(this.getLevelFullKey("button.delete"), new Object[]{this.getItemTypeDenotation()})));
    }

    protected void buildUI() {
        this.selectionTable.setSelectionMode(0);
        this.selectionTable.getSelectionModel().addListSelectionListener(e -> this.updateState(this.getTable().getSelectionModel().isSelectionEmpty()));
        NonvalidatingDialogButton createButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)new I18NText(this.getLevelFullKey("button.create"), new Object[]{this.getItemTypeDenotation()})));
        createButton.addActionListener(e -> new Thread(() -> this.createNewContentObject()).start());
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(e -> new Thread(() -> this.updateContentObjectAt(this.getSelectedIndex())).start());
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(e -> new Thread(() -> {
            int index = this.getSelectedIndex();
            Object[] parameters = new Object[]{this.getItemTypeDenotation(), this.getEntryIdentifier(index)};
            boolean deleteUserGroup = QuestionDialog.showYesNoDecisionDialog((WindowStack)this.getWindowStack(), (I18NKey)this.getLevelFullKey("question.remove.object"), (Object[])parameters);
            if (deleteUserGroup) {
                this.deleteContentObjectAt(index);
            }
        }).start());
        createButton.setEnabled(this.enableEditing());
        this.editButton.setEnabled(this.enableEditing());
        this.deleteButton.setEnabled(this.enableEditing());
        JPanel buttonPanel = new JPanel((LayoutManager)new StringGridBagLayout());
        buttonPanel.add("anchor=SOUTH,gridx=0,gridy=0,fill=HORIZONTAL,insets=[5,5,5,5]", (Component)createButton);
        buttonPanel.add("anchor=SOUTH,gridx=1,gridy=0,fill=HORIZONTAL,insets=[5,5,5,5]", this.editButton);
        buttonPanel.add("anchor=SOUTH,gridx=2,gridy=0,fill=HORIZONTAL,insets=[5,5,5,5]", this.deleteButton);
        JPanel contentPanel = new JPanel((LayoutManager)new StringGridBagLayout());
        contentPanel.add("anchor=SOUTH,gridx=0,gridy=0,fill=BOTH,weighty=1,insets=[5,5,5,5]", new JScrollPane((Component)this.getTable()));
        contentPanel.add("anchor=SOUTH,gridx=0,gridy=1,fill=HORIZONTAL,insets=[5,5,5,5]", buttonPanel);
        this.setContent(contentPanel);
        this.addButtons();
        this.updateState(true);
    }

    private String getItemTypeDenotation() {
        return this.itemTypeDenotation;
    }

    protected SchneideTable getTable() {
        return this.selectionTable;
    }

    protected int getSelectedIndex() {
        return this.getTable().getSelectedIndex();
    }

    protected void updateState(boolean noSelection) {
        this.editButton.setEnabled(!noSelection && this.enableEditing());
        this.deleteButton.setEnabled(!noSelection && this.enableEditing());
    }

    protected TableModel getTableModel() {
        return this.getTable().getModel();
    }

    protected abstract void addButtons();

    protected abstract void createNewContentObject();

    protected abstract void updateContentObjectAt(int var1);

    protected abstract void deleteContentObjectAt(int var1);

    protected abstract String getEntryIdentifier(int var1);

    private I18NKey getLevelFullKey(String parialKey) {
        return I18NKey.buildFromParts((String[])new String[]{"AbstractSchneideSelectionDialog", parialKey});
    }

    protected abstract boolean enableEditing();

    protected Optional<TYPE> giveAnswer() {
        return Optional.empty();
    }
}

