/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog;

import com.schneide.base.application.usermanagement.data.GenericSchneideCredential;
import com.schneide.base.application.usermanagement.dialog.helper.RightTreeModel;
import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.ValidatingDialogButton;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.inputs.CheckboxInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.BooleanValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.i18n.DefaultI18NValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.AbstractValidationResult;
import com.schneide.base.input.validation.ValidationAspect;
import com.schneide.base.input.validation.ValidationMessageType;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.input.validation.ValidationResultHolder;
import com.schneide.base.layout.StringGridBagLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class SchneideCredentialSelectionDialog
extends AbstractSchneideDialog<Iterable<SchneideCredential>> {
    private final BooleanValue isPermissionValue;
    private final BooleanValue includeInternalValue;
    private final boolean showInternalInformation;
    private final RightHandler rightHandler;
    private Iterable<Right> selectedRights;

    public SchneideCredentialSelectionDialog(WindowStack session, RightHandler rightHandler, boolean showInternalInformation) {
        super(session, (I18NKeyed)new I18NKey("SchneideCredentialSelectionDialog"));
        this.rightHandler = rightHandler;
        this.showInternalInformation = showInternalInformation;
        this.isPermissionValue = new BooleanValue((ValueInformation)new DefaultI18NValueInformation((I18NResolvable)this.getFullKey("input.is.permission")), Boolean.valueOf(true));
        this.includeInternalValue = new BooleanValue((ValueInformation)new DefaultI18NValueInformation((I18NResolvable)this.getFullKey("input.include.internal")), Boolean.valueOf(false));
        this.selectedRights = new ArrayList<Right>();
    }

    protected void setSelectedRights(TreePath ... paths) {
        ArrayList<Right> newSelectedRights = new ArrayList<Right>();
        for (TreePath path : paths) {
            if (!(path.getLastPathComponent() instanceof Right)) continue;
            newSelectedRights.add((Right)path.getLastPathComponent());
        }
        this.setSelectedRights(newSelectedRights);
    }

    protected void buildUI() {
        ArrayList<CheckboxInput> inputList = new ArrayList<CheckboxInput>();
        CheckboxInput isPermissionInput = new CheckboxInput((Value)this.isPermissionValue);
        inputList.add(isPermissionInput);
        CheckboxInput includeInternalInput = new CheckboxInput((Value)this.includeInternalValue);
        if (this.showInternalInformation) {
            inputList.add(includeInternalInput);
        }
        final JTree tree = new JTree(new RightTreeModel(this.rightHandler, this.showInternalInformation));
        tree.getSelectionModel().setSelectionMode(4);
        tree.addTreeSelectionListener(e -> this.setSelectedRights(tree.getSelectionPaths()));
        JScrollPane treeScrollPane = new JScrollPane(tree);
        treeScrollPane.setPreferredSize(new Dimension(500, 400));
        MouseAdapter clickListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selectedRow = tree.getRowForLocation(e.getX(), e.getY());
                if (-1 == selectedRow) {
                    return;
                }
                if (2 != e.getClickCount()) {
                    return;
                }
                TreePath selectedPath = tree.getPathForLocation(e.getX(), e.getY());
                if (0 > tree.getModel().getChildCount(selectedPath.getLastPathComponent())) {
                    return;
                }
                SchneideCredentialSelectionDialog.this.setSelectedRights(selectedPath);
                SchneideCredentialSelectionDialog.this.closeDialog(SchneideCredentialSelectionDialog.this.getCommitButton());
            }
        };
        tree.addMouseListener(clickListener);
        JPanel contentPanel = new JPanel((LayoutManager)new StringGridBagLayout());
        contentPanel.add("anchor=WEST,gridx=0,gridy=0,fill=HORIZONTAL,insets=[5,5,5,5]", this.buildInputContent(inputList.toArray(new Input[inputList.size()])));
        contentPanel.add("anchor=WEST,gridx=0,gridy=1,fill=BOTH,weighty=1,insets=[5,5,5,5]", treeScrollPane);
        this.addValidationAspects(new ValidationAspect[]{inputs -> {
            ValidationResultHolder validationResultHolder = new ValidationResultHolder();
            if (0 == IterableUtil.getSizeFor(this.getSelectedCredentials())) {
                validationResultHolder.addResult((ValidationResult)new NoRightSelectedError(this, this.getTextEntry("error.no.right.selected.message")));
            }
            return validationResultHolder;
        }});
        this.setContent(contentPanel);
        this.addButton().cancelButton();
        this.addButton().commitButton((DialogButton)new ValidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)this.getFullKey("button.select.credential")), (AbstractSchneideDialog)this));
    }

    protected void setSelectedRights(Iterable<Right> rights) {
        this.selectedRights = rights;
    }

    public Iterable<SchneideCredential> getSelectedCredentials() {
        ArrayList<SchneideCredential> result = new ArrayList<SchneideCredential>();
        for (Right selectedRight : this.selectedRights) {
            result.add(GenericSchneideCredential.buildSchneideCredential(selectedRight, this.isPermissionValue.getValue(), this.includeInternalValue.getValue()));
        }
        return result;
    }

    protected Optional<Iterable<SchneideCredential>> giveAnswer() {
        return Optional.ofNullable(this.getSelectedCredentials());
    }

    protected class NoRightSelectedError
    extends AbstractValidationResult {
        private final String categoryMessage;

        public NoRightSelectedError(SchneideCredentialSelectionDialog this$0, String categoryMessage) {
            this.categoryMessage = categoryMessage;
        }

        public boolean isCorrect() {
            return false;
        }

        public ValidationMessageType getMessageType() {
            return ValidationMessageType.ERROR;
        }

        public boolean needsDisplay() {
            return true;
        }

        public String getCategoryMessage() {
            return this.categoryMessage;
        }
    }
}

