/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog;

import com.schneide.base.application.usermanagement.dialog.helper.AbstractSchneideUserGroupDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.ValidatingDialogButton;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.validation.StringValidationAspect;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;

public class CreateSchneideUserGroupDialog<U extends SchneideUser>
extends AbstractSchneideUserGroupDialog<U> {
    public CreateSchneideUserGroupDialog(WindowStack session, boolean showInternalInformation, UserGroupHandler groupHandler, RightHandler rightHandler, AdditionalInputHandler<U> additionaInputCreator) {
        super(session, new I18NKey("CreateSchneideUserGroupDialog"), additionaInputCreator.createSchneideUserGroup("", null, false, (Iterable<SchneideCredential>)new EmptyIterable(), additionaInputCreator.getAdditionalSchneideUserGroupInputs()), showInternalInformation, groupHandler, rightHandler, additionaInputCreator);
        this.getNameValue().addStringValidationAspect((StringValidationAspect)new UniqueGroupNameValidationAspect(groupHandler));
    }

    @Override
    protected DialogButton createCommitButton() {
        return new ValidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)this.getFullKey("button.create.usergroup")), (AbstractSchneideDialog)this);
    }

    private static class UniqueGroupNameValidationAspect
    implements StringValidationAspect {
        private final UserGroupHandler groupHandler;

        public UniqueGroupNameValidationAspect(UserGroupHandler groupHandler) {
            this.groupHandler = groupHandler;
        }

        public ValidationResult validate(String currentText, Input source) {
            for (SchneideUserGroup group : this.groupHandler.getUserGroups()) {
                if (!currentText.equalsIgnoreCase(group.getName())) continue;
                return new InvalidInputResult(source, (I18NResolvable)new DirectText("Gruppen-Name bereits vergeben"));
            }
            return new ValidInputResult(source);
        }
    }
}

