/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog;

import com.schneide.base.application.usermanagement.dialog.helper.AbstractSchneideUserDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.ValidatingDialogButton;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.validation.StringValidationAspect;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;

public class CreateSchneideUserDialog<U extends SchneideUser>
extends AbstractSchneideUserDialog<U> {
    public CreateSchneideUserDialog(WindowStack session, boolean showInternalInformation, SchneideUserHandler<? extends SchneideUser> userHandler, UserGroupHandler groupHandler, RightHandler rightHandler, AdditionalInputHandler<U> additionalInputCreator) {
        super(session, new I18NKey("CreateSchneideUserDialog"), additionalInputCreator.createSchneideUser("", "", "", "", false, (Iterable<SchneideUserGroup>)new EmptyIterable(), (Iterable<SchneideCredential>)new EmptyIterable(), groupHandler, additionalInputCreator.getAdditionalSchneideUserInputs()), showInternalInformation, groupHandler, rightHandler, additionalInputCreator);
        this.getLoginValue().addStringValidationAspect((StringValidationAspect)new UniqueLoginValidationAspect(userHandler));
    }

    @Override
    protected void buildUI() {
        super.buildUI();
        this.changePassword("");
    }

    @Override
    protected DialogButton createCommitButton() {
        return new ValidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)this.getFullKey("button.create.user")), (AbstractSchneideDialog)this);
    }

    private static class UniqueLoginValidationAspect
    implements StringValidationAspect {
        private final SchneideUserHandler<? extends SchneideUser> userHandler;

        public UniqueLoginValidationAspect(SchneideUserHandler<? extends SchneideUser> userHandler) {
            this.userHandler = userHandler;
        }

        public ValidationResult validate(String currentText, Input source) {
            for (SchneideUser schneideUser : this.userHandler.getAll()) {
                if (!currentText.equalsIgnoreCase(schneideUser.getLogIn())) continue;
                return new InvalidInputResult(source, (I18NResolvable)new DirectText("Login bereits vergeben"));
            }
            return new ValidInputResult(source);
        }
    }
}

