/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.data;

import com.schneide.base.application.interaction.PermissionUnit;
import com.schneide.base.application.interaction.model.PermittableObject;
import com.schneide.base.application.usermanagement.model.RightIdentifier;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.UserManager;

public class UserPermissionUnit<U extends SchneideUser>
implements PermissionUnit {
    private final UserManager<U> userManager;
    private final U user;

    public UserPermissionUnit(UserManager<U> userManager, U user) {
        this.userManager = userManager;
        this.user = user;
    }

    @Override
    public boolean isPermitted(PermittableObject permittableObject) {
        if (permittableObject.isInternal() && !this.getUserManger().hasPermission(this.getUser(), new RightIdentifier("user.management.internal"))) {
            return false;
        }
        return this.getUserManger().hasPermission(this.getUser(), new RightIdentifier(permittableObject.getReferenceName()));
    }

    private U getUser() {
        return this.user;
    }

    private UserManager<U> getUserManger() {
        return this.userManager;
    }
}

