/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.data;

import com.schneide.base.application.usermanagement.data.CredentialType;
import com.schneide.base.application.usermanagement.model.CredentialValueChangeListener;
import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.datatypes.IdentifierGenerator;
import com.schneide.base.listener.ListenerContainer;

public class GenericSchneideCredential
implements SchneideCredential {
    private static final IdentifierGenerator IDENTIFIER = new IdentifierGenerator();
    private String identifier;
    private boolean isPermission;
    private final ListenerContainer<CredentialValueChangeListener> changeListeners = new ListenerContainer();
    private String description;
    private boolean isInternal;
    private String key;
    private CredentialType credentialType;

    public GenericSchneideCredential() {
    }

    public GenericSchneideCredential(String key, String description, CredentialType credentialType, boolean isInternal, boolean isPermission) {
        this();
        this.identifier = IDENTIFIER.getNextIdentifier();
        this.key = key;
        this.credentialType = credentialType;
        this.description = description;
        this.isPermission = isPermission;
        this.isInternal = isInternal;
    }

    public static SchneideCredential buildSchneideCredential(Right right, boolean isPermission, boolean includeInternal) {
        return new GenericSchneideCredential(right.getIdentifier(), right.getDenotation(), GenericSchneideCredential.determineCredentialType(includeInternal), right.getIsInternal(), isPermission);
    }

    private static CredentialType determineCredentialType(boolean includeInternal) {
        if (includeInternal) {
            return CredentialType.TOTAL;
        }
        return CredentialType.PUBLIC;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean getIsPermission() {
        return this.isPermission;
    }

    @Override
    public boolean getIsInternal() {
        return this.isInternal;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CredentialType getType() {
        return this.credentialType;
    }

    private void setType(CredentialType type) {
        this.credentialType = type;
    }

    public String getCredentialType() {
        return this.getType().name();
    }

    public void setCredentialType(String type) {
        this.setType(CredentialType.valueOf(type));
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setKey(String key) {
        this.key = key;
        this.notifyValueChanged();
    }

    @Override
    public void setIsPermission(boolean isPermission) {
        this.isPermission = isPermission;
        this.notifyValueChanged();
    }

    public void setDescription(String description) {
        this.description = description;
        this.notifyValueChanged();
    }

    public void setIsInternal(boolean isInternal) {
        this.isInternal = isInternal;
        this.notifyValueChanged();
    }

    protected void notifyValueChanged() {
        for (CredentialValueChangeListener changeListener : this.changeListeners.getListeners()) {
            changeListener.notifyCredentialValueChanged(this);
        }
    }

    @Override
    public void addCredentialValueChangeListener(CredentialValueChangeListener changeListener) {
        this.changeListeners.addListener((Object)changeListener);
    }

    @Override
    public void removeCredentialValueChangeListener(CredentialValueChangeListener changeListener) {
        this.changeListeners.removeListener((Object)changeListener);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchneideCredential) {
            SchneideCredential reference = (SchneideCredential)obj;
            return this.getKey().equals(reference.getKey());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

