/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.data;

import com.schneide.base.application.crypt.EncryptionException;
import com.schneide.base.application.usermanagement.crypto.Password;
import com.schneide.base.application.usermanagement.model.CredentialValueChangeListener;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserValueChangeListener;
import com.schneide.base.application.usermanagement.news.UserChanged;
import com.schneide.base.datatypes.IdentifierGenerator;
import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.listener.ListenerContainer;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BasicSchneideUser
extends LoggedObject
implements SchneideUser,
CredentialValueChangeListener {
    private static final IdentifierGenerator IDENTIFIER = new IdentifierGenerator();
    private String identifier;
    private String logIn;
    private String forename;
    private String surname;
    private Password password;
    private final List<SchneideUserGroup> groupList;
    private final List<SchneideCredential> credentialList;
    private final ListenerContainer<UserValueChangeListener> changeListeners;
    private boolean isInternal;
    private final EventBus eventBus;

    public BasicSchneideUser(String login, String forename, String surname, Password password, boolean isInternal, EventBus eventBus) {
        this.eventBus = eventBus;
        this.groupList = new ArrayList<SchneideUserGroup>();
        this.credentialList = new ArrayList<SchneideCredential>();
        this.changeListeners = new ListenerContainer();
        this.identifier = IDENTIFIER.getNextIdentifier();
        this.logIn = login;
        this.forename = forename;
        this.surname = surname;
        this.password = password;
        this.isInternal = isInternal;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getLogIn() {
        return this.logIn;
    }

    @Override
    public String getForename() {
        return this.forename;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public Password getPassword() {
        return this.password;
    }

    @Override
    public String getFullName() {
        DirectChunkBuffer chunkBuffer = new DirectChunkBuffer((CharSequence)" ");
        chunkBuffer.add((CharSequence)this.getForename());
        chunkBuffer.add((CharSequence)this.getSurname());
        return chunkBuffer.toString();
    }

    @Override
    public boolean isValidPassword(Password passwordCandidate) {
        try {
            return this.password.isSameAs(passwordCandidate);
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"Cannot verify password because of internal errors.", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean getIsInternal() {
        return this.isInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUserGroup(SchneideUserGroup group) {
        if (null == group) {
            return;
        }
        List<SchneideUserGroup> list = this.groupList;
        synchronized (list) {
            this.groupList.add(group);
            this.notifyValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserGroup(SchneideUserGroup group) {
        List<SchneideUserGroup> list = this.groupList;
        synchronized (list) {
            this.groupList.remove(group);
            this.notifyValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<SchneideUserGroup> getUserGroups() {
        List<SchneideUserGroup> list = this.groupList;
        synchronized (list) {
            ArrayList<SchneideUserGroup> result = new ArrayList<SchneideUserGroup>(this.groupList);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCredential(SchneideCredential credential) {
        if (credential != null) {
            List<SchneideCredential> list = this.credentialList;
            synchronized (list) {
                this.credentialList.add(credential);
                this.notifyValueChanged();
                credential.addCredentialValueChangeListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCredential(SchneideCredential credential) {
        List<SchneideCredential> list = this.credentialList;
        synchronized (list) {
            credential.removeCredentialValueChangeListener(this);
            this.credentialList.remove(credential);
            this.notifyValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<SchneideCredential> getCredentials() {
        List<SchneideCredential> list = this.credentialList;
        synchronized (list) {
            return new ArrayList<SchneideCredential>(this.credentialList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserGroups(Iterable<SchneideUserGroup> groupIdentifiers) {
        List<SchneideUserGroup> list = this.groupList;
        synchronized (list) {
            this.groupList.clear();
            CollectionUtil.addAll(this.groupList, groupIdentifiers);
            this.notifyValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(Iterable<SchneideCredential> credentials) {
        List<SchneideCredential> list = this.credentialList;
        synchronized (list) {
            this.credentialList.clear();
            CollectionUtil.addAll(this.credentialList, credentials);
            this.notifyValueChanged();
        }
    }

    public void setForename(String forename) {
        this.forename = forename;
        this.notifyValueChanged();
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLogIn(String logIn) {
        this.logIn = logIn;
        this.notifyValueChanged();
    }

    @Override
    public void changePassword(String newPassword) {
        try {
            this.password = Password.fromPlaintext(newPassword);
            this.notifyValueChanged();
        }
        catch (EncryptionException e) {
            this.getLogger().error((Object)"Cannot change password because the encryption failed.", (Throwable)e);
        }
    }

    public void setIsInternal(boolean isInternal) {
        this.isInternal = isInternal;
        this.notifyValueChanged();
    }

    public void setSurname(String surname) {
        this.surname = surname;
        this.notifyValueChanged();
    }

    @Override
    public void update(String login, String newForename, String newSurname, boolean newIsInternal, Iterable<SchneideUserGroup> groups, Iterable<SchneideCredential> credentials) {
        this.logIn = login;
        this.forename = newForename;
        this.surname = newSurname;
        this.isInternal = newIsInternal;
        this.setUserGroups(groups);
        this.setCredentials(credentials);
    }

    @Override
    public void notifyCredentialValueChanged(SchneideCredential newCredential) {
        this.notifyValueChanged();
    }

    protected void notifyValueChanged() {
        for (UserValueChangeListener changeListener : this.changeListeners.getListeners()) {
            changeListener.notifyUserValueChanged(this);
        }
        this.eventBus.publish((News)new UserChanged(this));
    }

    @Override
    public void addUserValueChangeListener(UserValueChangeListener changeListener) {
        this.changeListeners.addListener((Object)changeListener);
    }

    @Override
    public void removeUserValueChangeListener(UserValueChangeListener changeListener) {
        this.changeListeners.removeListener((Object)changeListener);
    }

    public int hashCode() {
        return Objects.hash(this.logIn);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSchneideUser other = (BasicSchneideUser)obj;
        return Objects.equals(this.logIn, other.logIn);
    }

    public String toString() {
        return this.getLogIn();
    }
}

