/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.data;

import com.schneide.base.application.interaction.model.ActionSpecification;
import com.schneide.base.application.interaction.model.ActionsSpecification;
import com.schneide.base.application.interaction.model.MenuBarSpecification;
import com.schneide.base.application.interaction.model.MenuItemSpecification;
import com.schneide.base.application.interaction.model.MenuItemType;
import com.schneide.base.application.interaction.model.MenuSpecification;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.internal.VolatileUserGroupHandler;
import com.schneide.base.application.usermanagement.internal.VolatileUserHandler;
import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.model.RightConfiguration;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.application.usermanagement.model.UserDataHolder;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.application.usermanagement.right.DefaultRightHandler;
import com.schneide.base.application.usermanagement.right.GenericRight;
import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.applicationLevel.StringsProperty;
import com.schneide.base.text.transformation.Embrace;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BaseUserDataHolder<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements UserDataHolder<U> {
    private RightHandler rightHandler;
    private UserGroupHandler userGroupHandler;
    private SchneideUserHandler<U> userHandler;
    private AdditionalInputHandler<U> additionalInputHandler;
    private Configuration userManagementConfiguration;

    public BaseUserDataHolder(Configuration userManagementConfiguration, MenuBarSpecification<S, U> menuBarSpecification, ActionsSpecification<S, U> actionsSpecification, AdditionalInputHandler<U> additionalInputHandler) {
        this.userManagementConfiguration = userManagementConfiguration;
        this.additionalInputHandler = additionalInputHandler;
        DefaultRightHandler newRightHandler = new DefaultRightHandler(new RightConfiguration(){

            @Override
            public File[] getInternalRightConfigurationFiles() {
                return BaseUserDataHolder.this.getInternalRightConfigurationFiles();
            }

            @Override
            public File[] getRightConfigurationFiles() {
                return BaseUserDataHolder.this.getRightConfigurationFiles();
            }
        });
        this.fillRightHandler(newRightHandler, menuBarSpecification, actionsSpecification);
        this.rightHandler = newRightHandler;
        this.userGroupHandler = new VolatileUserGroupHandler();
        this.userHandler = new VolatileUserHandler(this.userGroupHandler);
    }

    protected void fillRightHandler(DefaultRightHandler currentRightHandler, MenuBarSpecification<S, U> menuBarSpecification, ActionsSpecification<S, U> actionsSpecification) {
        ArrayList<ActionSpecification<S, U>> actionList = new ArrayList<ActionSpecification<S, U>>();
        CollectionUtil.addAll(actionList, actionsSpecification.getActions());
        GenericRight serveranwendungMen\u00fc = new GenericRight("serverside menu", "Administrationsmen\u00fc");
        currentRightHandler.addRight(serveranwendungMen\u00fc);
        for (MenuSpecification menuSpecification : menuBarSpecification.getMenus()) {
            GenericRight genericRight = new GenericRight(menuSpecification.getReferenceName(), new DirectText("[Men\u00fc] {0}", new Object[]{menuSpecification.getDisplayText()}).resolvedText());
            genericRight.setParentRight(serveranwendungMen\u00fc);
            this.hookDependentRights(currentRightHandler, genericRight);
            for (MenuItemSpecification itemSpecification : menuSpecification.getMenuItems()) {
                if (MenuItemType.SEPARATOR.equals((Object)itemSpecification.getMenuItemType())) continue;
                GenericRight right = new GenericRight(itemSpecification.getReferenceName(), new DirectText("[Men\u00fceintrag] {0}", new Object[]{itemSpecification.getDisplayText()}).resolvedText());
                right.setParentRight(genericRight);
                this.removeAction(itemSpecification.getActionReference(), actionList);
            }
        }
        GenericRight bedienmen\u00fc = new GenericRight("web gui menu", "Bedienmen\u00fc");
        currentRightHandler.addRight(bedienmen\u00fc);
        for (ActionSpecification actionSpecification : actionList) {
            GenericRight actionBasedRight = new GenericRight(actionSpecification.getReferenceName(), actionSpecification.getProcessDisplayName() + " " + Embrace.withParentheses((Object)actionSpecification.getReferenceName()));
            actionBasedRight.setIsInternal(actionSpecification.isInternal());
            actionBasedRight.setParentRight(bedienmen\u00fc);
            this.hookDependentRights(currentRightHandler, actionBasedRight);
        }
    }

    protected void hookDependentRights(DefaultRightHandler currentRightHandler, Right right) {
        Iterable<Right> dependentRights = currentRightHandler.getDependentRightsFor(right.getIdentifier());
        for (Right dependent : dependentRights) {
            dependent.setParentRight(right);
            currentRightHandler.removeRight(dependent);
        }
    }

    private void removeAction(String referenceName, List<ActionSpecification<S, U>> actionList) {
        Iterator<ActionSpecification<S, U>> iterator = actionList.iterator();
        while (iterator.hasNext()) {
            ActionSpecification<S, U> actionSpecification = iterator.next();
            if (!referenceName.equals(actionSpecification.getReferenceName())) continue;
            iterator.remove();
        }
    }

    protected final File[] getRightConfigurationFiles() {
        return this.getFiles("right.configuration.file");
    }

    protected final File[] getInternalRightConfigurationFiles() {
        return this.getFiles("right.configuration.file.internal");
    }

    private File[] getFiles(String key) {
        String[] rightConfigurationsFilenames = StringsProperty.buildConfigured((ConfigurationPart)this.userManagementConfiguration, (PropertyReferenceType)PropertyReference.forKey((String)key)).getValues();
        if (rightConfigurationsFilenames == null) {
            return new File[0];
        }
        File[] rightConfigurationFiles = new File[rightConfigurationsFilenames.length];
        for (int i = 0; i < rightConfigurationFiles.length; ++i) {
            rightConfigurationFiles[i] = FileLocator.getFile((String)rightConfigurationsFilenames[i]);
        }
        return rightConfigurationFiles;
    }

    @Override
    public RightHandler getRightHandler() {
        return this.rightHandler;
    }

    @Override
    public UserGroupHandler getSchneideUserGroupHandler() {
        return this.userGroupHandler;
    }

    @Override
    public SchneideUserHandler<U> getUserHandler() {
        return this.userHandler;
    }

    public void setSchneideUserGroupHandler(UserGroupHandler newUserGroupHandler) {
        this.userGroupHandler = newUserGroupHandler;
    }

    public void setSchneideUserHandler(SchneideUserHandler<U> newUserHandler) {
        this.userHandler = newUserHandler;
    }

    @Override
    public AdditionalInputHandler<U> getAdditionalInputHandler() {
        return this.additionalInputHandler;
    }

    @Override
    public void destroy() {
    }

    protected Configuration getUserManagementConfiguration() {
        return this.userManagementConfiguration;
    }
}

