/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.crypto;

import com.schneide.base.application.crypt.CryptographyService;
import com.schneide.base.application.crypt.EncryptionException;
import com.schneide.base.system.Base;
import java.io.IOException;
import java.io.Serializable;

public class Password
implements Serializable {
    public static final Password NONE = new Password("");
    private static final long serialVersionUID = 3374427812028499207L;
    private static final String BASE64_PREFIX = "BASE64:";
    private final String base64Hash;

    public Password(String base64Hash) {
        this.base64Hash = base64Hash;
    }

    public static Password fromPlaintext(String plaintext) throws EncryptionException {
        return new Password(Password.digest(plaintext));
    }

    public String asDigest() {
        return this.base64Hash;
    }

    private static String digest(String plainText) throws EncryptionException {
        return BASE64_PREFIX + CryptographyService.getBase64EncodedDigestOf(plainText);
    }

    public boolean isSameAs(Password other) {
        return this.asDigest().equals(other.asDigest());
    }

    public static String convertIfNecessary(String hashedPassword, String context) throws IOException {
        if (hashedPassword.startsWith(BASE64_PREFIX)) {
            Base.getLogger(Password.class).debug((Object)("Password hash of " + context + " already is in BASE64, no migration needed."));
            return hashedPassword;
        }
        String base64Encoded = CryptographyService.encodeBase64(hashedPassword);
        return BASE64_PREFIX + base64Encoded;
    }
}

