/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.statusbar.news;

import com.schneide.base.application.news.SystemMessage;
import com.schneide.base.application.statusbar.StatusPanel;
import com.schneide.base.application.statusbar.StatusbarManager;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.timing.Clock;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewsDrivenStatusbarManager
extends LoggedObject
implements StatusbarManager,
NewsReceiver<SystemMessage> {
    private final JPanel statusBar;
    private final JLabel statusLabel;

    public NewsDrivenStatusbarManager() {
        EDT.always();
        this.statusBar = new JPanel();
        this.statusBar.setName("mainFrame.statusbar");
        this.statusBar.setPreferredSize(new Dimension(0, 25));
        this.statusBar.removeAll();
        this.statusBar.setLayout((LayoutManager)new StringGridBagLayout());
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        this.statusLabel = new JLabel();
        this.statusBar.add("anchor=WEST, insets=[1,7,1,7], fill=NONE", this.statusLabel);
        this.statusBar.revalidate();
    }

    public void subscribeTo(EventBus eventBus) {
        eventBus.subscribe((NewsReceiver)this, SystemMessage.class);
    }

    public void receive(SystemMessage news) {
        DirectText message = new DirectText("<html>Letzte Meldung ({0}): <b>{1}</b></html>", new Object[]{Clock.getDateTimeString(), news.asString()});
        EDT.perform(() -> this.statusLabel.setText(message.resolvedText()));
    }

    @Override
    public JPanel getStatusBar() {
        return this.statusBar;
    }

    @Override
    public StatusPanel getStatusPanel(String identifier) throws NoSuchElementException {
        throw new NoSuchElementException("No different status panels for the EventBus driven status bar (asked for " + identifier + ")");
    }

    public Class<SystemMessage> expectedNewsType() {
        return SystemMessage.class;
    }
}

