/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.statusbar.gui;

import com.schneide.base.application.statusbar.StatusPanelSpecification;
import com.schneide.base.application.statusbar.gui.AbstractSchneideStatusPanel;
import com.schneide.base.layout.StringGridBagLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class Statusbar
extends JPanel {
    private static final long serialVersionUID = -2478153607317260315L;

    public Statusbar(AbstractSchneideStatusPanel ... statusPanels) {
        super((LayoutManager)new StringGridBagLayout());
        this.setName("mainFrame.statusbar");
        this.buildUI(statusPanels);
    }

    private void buildUI(AbstractSchneideStatusPanel[] statusPanels) {
        this.setPreferredSize(new Dimension(0, 30));
        this.setBorder(BorderFactory.createEtchedBorder());
        HashMap<Integer, ArrayList<AbstractSchneideStatusPanel>> statusContentMap = new HashMap<Integer, ArrayList<AbstractSchneideStatusPanel>>();
        for (AbstractSchneideStatusPanel statusPanel : statusPanels) {
            int position = statusPanel.getSpecification().getPosition();
            ArrayList<AbstractSchneideStatusPanel> panelList = (ArrayList<AbstractSchneideStatusPanel>)statusContentMap.get(position);
            if (panelList == null) {
                panelList = new ArrayList<AbstractSchneideStatusPanel>();
                statusContentMap.put(position, panelList);
            }
            panelList.add(statusPanel);
        }
        ArrayList statusGroups = new ArrayList();
        statusGroups.addAll(statusContentMap.keySet());
        Collections.sort(statusGroups);
        int column = 0;
        Iterator iterator = statusGroups.iterator();
        while (iterator.hasNext()) {
            int statusGroup = (Integer)iterator.next();
            JPanel orientationPanel = this.createOrientationPanel((List)statusContentMap.get(statusGroup));
            this.add("anchor=west,gridx=" + column + ",gridy=0,fill=BOTH,insets=[0,0,0,0]", orientationPanel);
            ++column;
        }
        this.revalidate();
    }

    protected JPanel createOrientationPanel(List<AbstractSchneideStatusPanel> panelList) {
        JPanel orientationPanel = new JPanel((LayoutManager)new StringGridBagLayout());
        orientationPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        if (null == panelList) {
            return orientationPanel;
        }
        Collections.sort(panelList, (o1, o2) -> o1.getSpecification().getInternalPostion() - o2.getSpecification().getInternalPostion());
        int oColumn = 0;
        for (AbstractSchneideStatusPanel statusPanel : panelList) {
            StatusPanelSpecification specification = statusPanel.getSpecification();
            statusPanel.setMinimumSize(new Dimension(specification.getWidth(), 30));
            statusPanel.setPreferredSize(new Dimension(specification.getWidth(), 30));
            statusPanel.setMaximumSize(new Dimension(specification.getWidth(), 30));
            orientationPanel.add("anchor=WEST,gridx=" + oColumn + ",gridy=0,fill=BOTH,insets=[0,0,0,0]", statusPanel);
            ++oColumn;
        }
        return orientationPanel;
    }
}

