/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.statusbar;

import com.schneide.base.application.gui.news.ApplicationFrameClosed;
import com.schneide.base.application.news.SystemMessage;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.layout.StringGridBagLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleStatusbar<S extends SchneideSession<U>, U extends SchneideUser>
extends JPanel {
    private static final long serialVersionUID = -4289419680110358790L;
    private final S session;
    private final Subscriber<SystemMessage> messages;
    private final JLabel recentMessage;

    public SimpleStatusbar(S session) {
        this.session = session;
        EDT.always();
        this.setName("mainFrame.statusbar");
        this.recentMessage = (JLabel)EDT.query(JLabel::new);
        this.messages = new Subscriber(SystemMessage.class, news -> EDT.perform(() -> this.recentMessage.setText(news.asString())));
        this.buildUI();
    }

    private void buildUI() {
        this.setPreferredSize(new Dimension(0, 25));
        this.removeAll();
        this.setLayout((LayoutManager)new StringGridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addSystemMessages();
        this.addUserEntry();
        this.revalidate();
    }

    private void addSystemMessages() {
        this.add("anchor=WEST, insets=[1,7,1,7], fill=NONE", this.recentMessage);
        Subscriber.attach(this.messages, (EventBus)this.session.getApplicationBus()).untilReceiving(ApplicationFrameClosed.class);
    }

    private void addUserEntry() {
        String userNameKey = new I18NKey("Statusbar.username.short").resolvedText();
        String toolTip = new I18NKey("Statusbar.username.tooltip").getResolvedText(new Object[]{this.session.getUser().getLogIn()});
        JLabel userEntry = new JLabel(userNameKey + " " + this.session.getUser().getFullName());
        userEntry.setToolTipText(toolTip);
        this.add("anchor=EAST, insets=[1,7,1,7], fill=NONE", userEntry);
    }
}

