/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.session;

import com.schneide.base.application.AbstractSession;
import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.configuration.ConfigurationContext;
import com.schneide.base.application.configuration.implementation.DefaultConfigurationContexts;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.PermissionDecider;
import com.schneide.base.application.usermanagement.model.RightIdentifier;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.gui.GenericWindowStack;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.lifecycle.Stoppable;
import com.schneide.base.lifecycle.dependent.DisposeDependentResources;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class BasicSchneideSession<S extends SchneideSession<U>, U extends SchneideUser>
extends AbstractSession
implements SchneideSession<U> {
    private final U user;
    private final PermissionDecider<U> userManager;
    private final ActionManager<S, U> actionManager;
    private final SchneideApplication application;
    private final Map<Object, Object> sessionPropertyMap;
    private final List<Stoppable> dependentResources;

    public BasicSchneideSession(U user, PermissionDecider<U> userManager, SchneideApplication application, ActionManager<S, U> actionManager) {
        super(user.getLogIn());
        this.user = user;
        this.userManager = userManager;
        this.application = application;
        this.actionManager = actionManager;
        this.sessionPropertyMap = new HashMap<Object, Object>();
        this.dependentResources = new ArrayList<Stoppable>();
    }

    @Override
    public EventBus getApplicationBus() {
        return this.application.getApplicationBus();
    }

    @Override
    public final ConfigurationContext getConfigurationContext() {
        return DefaultConfigurationContexts.SESSION;
    }

    @Override
    public final String getProperty(String key) throws NoSuchElementException {
        String result = this.getProperty(key, null);
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException("Eintrag nicht gefunden.");
    }

    @Override
    public final String getProperty(String key, String fallbackValue) {
        Optional<Object> result;
        if (this.hasProperty(key) && (result = this.getSessionProperty(key)) instanceof String) {
            return (String)((Object)result);
        }
        return fallbackValue;
    }

    @Override
    public final boolean hasProperty(String key) {
        return this.getSessionProperty(key).isPresent();
    }

    @Override
    public final void setProperty(String key, String value) {
        this.setSessionProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionProperty(Object key, Object value) {
        if (key != null) {
            Map<Object, Object> map = this.sessionPropertyMap;
            synchronized (map) {
                this.sessionPropertyMap.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Object> getSessionProperty(Object key) {
        if (key != null) {
            Map<Object, Object> map = this.sessionPropertyMap;
            synchronized (map) {
                if (this.sessionPropertyMap.containsKey(key)) {
                    return Optional.ofNullable(this.sessionPropertyMap.get(key));
                }
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeSessionProperty(Object key) {
        if (key != null) {
            Map<Object, Object> map = this.sessionPropertyMap;
            synchronized (map) {
                return this.sessionPropertyMap.remove(key);
            }
        }
        return null;
    }

    private GenericWindowStack getStackFor(WindowStack stack) {
        if (null == stack || !this.hasWindowStack(stack.getIdentifier())) {
            return this.getMainWindowStack();
        }
        return this.getWindowStack(stack.getIdentifier());
    }

    @Override
    public void showWindow(Window window) {
        this.showWindow((WindowStack)this.getMainWindowStack(), window);
    }

    @Override
    public void showWindow(WindowStack stack, Window window) {
        GenericWindowStack realStack = this.getStackFor(stack);
        if (window instanceof Frame && realStack.getWindowStack().isEmpty()) {
            realStack.setAbstractMainFrame((Frame)window);
        }
        realStack.getWindowStack().push((Object)window);
    }

    @Override
    public void hideWindow(Window window) {
        this.hideWindow((WindowStack)this.getMainWindowStack(), window);
    }

    @Override
    public void hideWindow(WindowStack stack, Window window) {
        GenericWindowStack realStack = this.getStackFor(stack);
        if (realStack.getWindowStack().isEmpty()) {
            return;
        }
        this.hideMainFrame(realStack, window);
        realStack.getWindowStack().pop();
    }

    private void hideMainFrame(GenericWindowStack realStack, Window window) {
        if (!(window instanceof Frame)) {
            return;
        }
        if (realStack.hasMainFrame() && this.isMainFrame(window)) {
            realStack.setAbstractMainFrame(null);
        }
    }

    @Override
    public U getUser() {
        return this.user;
    }

    @Override
    public boolean isAllowed(RightIdentifier credentialIdentifier) {
        return this.userManager.hasPermission(this.getUser(), credentialIdentifier);
    }

    @Override
    public void destroyVisualContent() {
        for (WindowStack stack : this.getWindowStacks()) {
            this.destroyVisualContentOf(stack);
        }
    }

    public void destroyVisualContentOf(WindowStack stack) {
        Window activeWindow;
        do {
            activeWindow = stack.getActiveWindow();
            this.hideWindow(stack, activeWindow);
            activeWindow.dispose();
        } while (stack.getAbstractMainFrame() != activeWindow);
    }

    @Override
    public ActionManager<S, U> getActionManager() {
        return this.actionManager;
    }

    @Override
    public SchneideApplication getApplication() {
        return this.application;
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<Stoppable> list = this.dependentResources;
        synchronized (list) {
            DisposeDependentResources.givenBy(this.dependentResources);
        }
    }

    public void addDependent(LifeCycle resource) {
        this.add((Stoppable)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Stoppable dependent) {
        List<Stoppable> list = this.dependentResources;
        synchronized (list) {
            this.dependentResources.add(dependent);
        }
    }
}

