/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.session;

import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.session.SessionHandler;
import com.schneide.base.application.usermanagement.model.PermissionDecider;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSessionHandler<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements SessionHandler<S, U> {
    private final Map<String, List<S>> sessionMap = new HashMap<String, List<S>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final S createSessionFor(U user, PermissionDecider<U> permissions, SchneideApplication application, ActionManager<S, U> actionManager) {
        if (user != null) {
            S result = this.buildSession(user, permissions, application, actionManager);
            Map<String, List<S>> map = this.sessionMap;
            synchronized (map) {
                this.sessionMap.computeIfAbsent(this.keyOf(user), s -> new ArrayList()).add(result);
            }
            return result;
        }
        return null;
    }

    private String keyOf(U user) {
        return user.getLogIn();
    }

    protected abstract S buildSession(U var1, PermissionDecider<U> var2, SchneideApplication var3, ActionManager<S, U> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endSession(S session) {
        if (session != null) {
            Map<String, List<S>> map = this.sessionMap;
            synchronized (map) {
                List<S> sessionList = this.sessionMap.get(this.keyOf(session.getUser()));
                sessionList.remove(session);
                if (sessionList.isEmpty()) {
                    this.sessionMap.remove(this.keyOf(session.getUser()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasActiveSessions(U sessionUser) {
        if (null == sessionUser) {
            return false;
        }
        Map<String, List<S>> map = this.sessionMap;
        synchronized (map) {
            return this.sessionMap.containsKey(this.keyOf(sessionUser));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<S> sessionsFor(U user) {
        Map<String, List<S>> map = this.sessionMap;
        synchronized (map) {
            return new ArrayList(this.sessionMap.getOrDefault(this.keyOf(user), Collections.emptyList()));
        }
    }
}

