/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.selection;

import com.schneide.base.application.process.cron.CronProcessExecutionSpecification;
import com.schneide.base.application.selection.ProcessExecutionSelection;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.input.inputs.CheckboxInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.BooleanValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.i18n.DirectValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import java.util.List;
import java.util.Optional;

public class CronProcessSelectorDialog
extends AbstractSchneideDialog<Iterable<ProcessExecutionSelection>> {
    private final CronProcessExecutionSelection[] selections;

    public CronProcessSelectorDialog(WindowStack windowStack, CronProcessExecutionSpecification ... specifications) {
        super(windowStack, "CronProcessSelectorDialog");
        this.selections = new CronProcessExecutionSelection[specifications.length];
        for (int i = 0; i < specifications.length; ++i) {
            this.selections[i] = new CronProcessExecutionSelection(this, specifications[i]);
        }
    }

    protected void buildUI() {
        Input[] inputs = new Input[this.selections.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = new CheckboxInput((Value)this.selections[i].getScheduleEnablingValue());
        }
        this.buildInputDialog(this.getTextEntry("message"), inputs);
    }

    protected Optional<Iterable<ProcessExecutionSelection>> giveAnswer() {
        return Optional.of(List.of(this.selections));
    }

    public ProcessExecutionSelection[] getSelections() {
        return this.selections;
    }

    private class CronProcessExecutionSelection
    implements ProcessExecutionSelection {
        private final CronProcessExecutionSpecification specification;
        private final BooleanValue isEnabledForSchedule;

        public CronProcessExecutionSelection(CronProcessSelectorDialog cronProcessSelectorDialog, CronProcessExecutionSpecification specification) {
            this.specification = specification;
            this.isEnabledForSchedule = new BooleanValue((ValueInformation)new DirectValueInformation(specification.getProcessName(), new I18NText(cronProcessSelectorDialog.getI18NBase().withKeyPart("selection.tooltip"), new Object[]{specification.getDenotation()}).resolvedText()), Boolean.valueOf(specification.isEnabled()));
        }

        @Override
        public boolean isEnabledForSchedule() {
            return this.isEnabledForSchedule.getValue();
        }

        @Override
        public CronProcessExecutionSpecification getSpecification() {
            return this.specification;
        }

        public BooleanValue getScheduleEnablingValue() {
            return this.isEnabledForSchedule;
        }
    }
}

