/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.progress;

import com.schneide.base.application.progress.AbstractDelay;
import com.schneide.base.application.progress.DelayDialog;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.gui.dialog.button.DialogButtonHandler;
import com.schneide.base.threading.SchneideThread;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DelayHandler
implements ChangeListener,
DialogButtonHandler {
    private final SchneideSession<?> session;
    private AbstractDelay delay;
    private DelayDialog dialog;

    public DelayHandler(SchneideSession<?> session) {
        this.session = session;
    }

    public void handleDelay(AbstractDelay newDelay) {
        if (newDelay != null) {
            this.delay = newDelay;
            this.dialog = new DelayDialog(this.session, this.delay.getTitle(), this.delay.getDescription(), this.delay, this, this.delay.canGiveTextualProgress(), this.delay.canShowTime(), this.delay.canEstimateTime());
            this.delay.addChangeListener(this);
            new SchneideThread(() -> this.dialog.showDialog(), "DelayVisualizer").startThread();
            this.delay.valueChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.delay) {
            this.dialog.setTextualProgress(this.delay.getProgressText());
            this.dialog.setElapsedTime(this.delay.getElapsedTimeText());
            this.dialog.setEstimatedTime(this.delay.getEstimatedTimeText());
            this.updateDisposeButton();
            this.dialog.repack();
        }
    }

    private void updateDisposeButton() {
        if (this.delay.canAutoDispose()) {
            if (this.delay.isFinished()) {
                this.dialog.hideDialog();
            }
        } else {
            this.dialog.getDisposeButton().setEnabled(this.delay.isFinished());
        }
    }

    public boolean handleDialogButtonActivation(JButton button) {
        if (button == this.dialog.getDisposeButton()) {
            return this.delay.isFinished();
        }
        return false;
    }
}

