/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.progress;

import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.DialogButtonHandler;
import com.schneide.base.gui.dialog.button.HandledDialogButton;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.input.inputs.LabelInput;
import com.schneide.base.input.types.StringValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.i18n.DirectValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.layout.GridBagLayoutPanel;
import com.schneide.base.layout.GridPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Optional;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DelayDialog
extends AbstractSchneideDialog<Void> {
    private final StringValue textualProgress;
    private final StringValue elapsedTime;
    private final StringValue estimatedTime;
    private final DialogButton disposeButton;
    private final JProgressBar progress;
    private final LabelInput textualProgressInput;
    private final LabelInput elapsedTimeInput;
    private final LabelInput estimatedTimeInput;
    private boolean hasTextualProgress;
    private boolean hasElapsedTime;
    private boolean hasEstimatedTime;
    private final JPanel contentPanel;
    private final String title;

    public DelayDialog(SchneideSession<?> session, String title, String message, BoundedRangeModel model, DialogButtonHandler buttonHandler, boolean hasTextualProgress, boolean hasElapsedTime, boolean hasEstimatedTime) {
        super(session.getMainWindowStack(), (I18NKeyed)new I18NKey("DelayDialog"));
        this.title = title;
        this.hasTextualProgress = hasTextualProgress;
        this.hasElapsedTime = hasElapsedTime;
        this.hasEstimatedTime = hasEstimatedTime;
        this.textualProgress = new StringValue((ValueInformation)new DirectValueInformation("verbaler Fortschritt", "Zeigt den Fortschritt in verbaler Form an."), "nicht bekannt");
        this.elapsedTime = new StringValue((ValueInformation)new DirectValueInformation("bisherige Dauer", "Die bisherige Dauer dieses Vorgangs im Format hh:mm:ss"), "00:00:00");
        this.estimatedTime = new StringValue((ValueInformation)new DirectValueInformation("gesch\u00e4tzte Restlaufzeit", "Die auf den vorliegenden Daten basierende Sch\u00e4tzung der Restlaufzeit"), "00:00:00");
        this.textualProgressInput = new LabelInput((Value)this.textualProgress);
        this.elapsedTimeInput = new LabelInput((Value)this.elapsedTime);
        this.estimatedTimeInput = new LabelInput((Value)this.estimatedTime);
        this.progress = new JProgressBar(model);
        this.progress.setStringPainted(true);
        this.disposeButton = new HandledDialogButton("Schlie\ufffden", "Fortschrittsanzeige schlie\ufffden", buttonHandler);
        this.disposeButton.setEnabled(false);
        this.contentPanel = new JPanel(new FlowLayout());
        this.rebuildUI();
        this.setContent(this.contentPanel);
        this.addMessage(message);
        this.addButton().commitButton(this.disposeButton);
    }

    protected void buildUI() {
        this.rebuildUI();
    }

    public void isTextualProgressShown(boolean visibility) {
        this.hasTextualProgress = visibility;
        this.rebuildUI();
    }

    public void isElapsedTimeShown(boolean visibility) {
        this.hasElapsedTime = visibility;
        this.rebuildUI();
    }

    public void isEstimatedTimeShown(boolean visibility) {
        this.hasEstimatedTime = visibility;
        this.rebuildUI();
    }

    public void setTextualProgress(String content) {
        this.textualProgress.setValue(content);
    }

    public void setElapsedTime(String content) {
        this.elapsedTime.setValue(content);
    }

    public void setEstimatedTime(String content) {
        this.estimatedTime.setValue(content);
    }

    public DialogButton getDisposeButton() {
        return this.disposeButton;
    }

    private void rebuildUI() {
        this.setTitle(this.title);
        GridHandler gridHandler = new GridHandler();
        gridHandler.addInNextLine(new JLabel(new DirectText("Fortschritt:").resolvedText()));
        gridHandler.addInNextLine(this.progress);
        gridHandler.addInNextLineIf((JComponent)this.textualProgressInput, this.hasTextualProgress);
        if (this.hasTimeBlock()) {
            gridHandler.addInNextLine(new JLabel(""));
            gridHandler.addInNextLine(new JLabel(new DirectText("Zeit:").resolvedText()));
            gridHandler.addInNextLineIf((JComponent)this.elapsedTimeInput, this.hasElapsedTime);
            gridHandler.addInNextLineIf((JComponent)this.estimatedTimeInput, this.hasEstimatedTime);
        }
        this.contentPanel.removeAll();
        this.contentPanel.add((Component)gridHandler.getGrid());
    }

    private boolean hasTimeBlock() {
        return this.hasElapsedTime || this.hasEstimatedTime;
    }

    protected Optional<Void> giveAnswer() {
        return Optional.empty();
    }

    private static class GridHandler {
        private final GridPanel gridPanel = new GridBagLayoutPanel();
        private int line = 0;

        public void addInNextLine(JComponent component) {
            this.gridPanel.add("anchor=WEST, fill=HORIZONTAL, insets=[5,5,5,5], gridx=0, gridy=" + this.line, (Component)component);
            ++this.line;
        }

        public void addInNextLineIf(JComponent component, boolean condition) {
            if (!condition) {
                return;
            }
            this.addInNextLine(component);
        }

        public GridPanel getGrid() {
            return this.gridPanel;
        }
    }
}

