/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.progress;

import com.schneide.base.application.progress.AbstractDelay;
import com.schneide.base.maths.Mathematics;
import com.schneide.base.system.Base;
import java.text.DecimalFormat;

public class ContinousDelay
extends AbstractDelay {
    private final double resolutionFactor;
    private final DecimalFormat percentageFormatter;

    public ContinousDelay(String title, String description, double maximalValue) {
        this(title, description, 0.0, maximalValue);
    }

    public ContinousDelay(String title, String description, double minimalValue, double maximalValue) {
        this(title, description, minimalValue, minimalValue, maximalValue);
    }

    public ContinousDelay(String title, String description, double minimalValue, double actualValue, double maximalValue) {
        super(title, description, false, true, false, true);
        this.resolutionFactor = 100.0;
        this.percentageFormatter = ContinousDelay.getDecimalFormatFor(this.resolutionFactor);
        this.setRangeProperties((int)(actualValue * this.resolutionFactor), 0, (int)(minimalValue * this.resolutionFactor), (int)(maximalValue * this.resolutionFactor), this.getValueIsAdjusting());
    }

    public void setProgressValue(double value) {
        this.setValue((int)(value * this.resolutionFactor));
    }

    public double getProgressValue() {
        return (double)this.getValue() / this.resolutionFactor;
    }

    private static DecimalFormat getDecimalFormatFor(double resolutionFactor) {
        int decimalPlacesCount = (int)Math.round(Mathematics.lg((double)resolutionFactor));
        StringBuffer format = new StringBuffer();
        format.append("0.");
        for (int i = 0; i < decimalPlacesCount; ++i) {
            format.append("0");
        }
        return new DecimalFormat(format.toString());
    }

    @Override
    public String getProgressText() {
        return Base.getTextContent().getParametrizedText("ContinousDelay.message", new Object[]{this.percentageFormatter.format(this.getProcessedPercentage() * 100.0)});
    }
}

